/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin.base.network.request;

import com.qihoo.livecloud.plugin.base.network.HttpError;
import com.qihoo.livecloud.plugin.base.network.HttpRequest;
import com.qihoo.livecloud.plugin.base.network.request.JsonRequestListener;
import com.qihoo.livecloud.plugin.base.utils.ThreadUtils;
import com.qihoo.livecloud.tools.Logger;
import java.io.IOException;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonRequest
extends HttpRequest<JSONObject> {
    private static final String TAG = JsonRequest.class.getSimpleName();
    public final JsonRequestListener mJsonListener;

    public JsonRequest(String url, JsonRequestListener listener) {
        this(0, url, listener);
    }

    public JsonRequest(int method, String url, JsonRequestListener listener) {
        super(method, url, null);
        this.mJsonListener = listener;
    }

    @Override
    public void onFailure(HttpError e) {
        if (this.mJsonListener == null) {
            return;
        }
        Logger.d(TAG, "onFailure:e:" + e);
        this.onFailure(e, -1, null);
    }

    protected JSONObject parseJsonObj(Response response) {
        JSONObject jsonObj = null;
        try {
            jsonObj = new JSONObject(response.body().string());
        }
        catch (IOException | JSONException throwable) {
            // empty catch block
        }
        return jsonObj;
    }

    protected void onResponse(final JSONObject jsonObject) {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (JsonRequest.this.mJsonListener == null) {
                    return;
                }
                JsonRequest.this.mJsonListener.onResponse(jsonObject);
            }
        });
    }

    protected void onFailure(final HttpError e, final int errno, final String msg) {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (JsonRequest.this.mJsonListener == null) {
                    return;
                }
                JsonRequest.this.mJsonListener.onFailure(e, errno, msg);
            }
        });
    }

    @Override
    public void onResponse(Response response) {
        if (this.mJsonListener == null) {
            return;
        }
        if (response == null) {
            this.onFailure(new HttpError("", 1));
            return;
        }
        JSONObject jsonObj = this.parseJsonObj(response);
        Logger.d(TAG, "onResponse:jsonObj:" + jsonObj);
        if (jsonObj == null) {
            this.onFailure(new HttpError("", 2));
            return;
        }
        int nErroNo = this.getJsonErrorNO(jsonObj);
        if (nErroNo != 0) {
            this.onFailure(null, nErroNo, this.getJsonErrorMessage(jsonObj));
        } else {
            this.onResponse(jsonObj);
        }
    }

    private int getJsonErrorNO(JSONObject jsonObj) {
        try {
            return jsonObj.getInt("errno");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private String getJsonErrorMessage(JSONObject jsonObj) {
        try {
            return jsonObj.getString("errmsg");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

