/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin.base.network.request;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class ProgressRequestBody
extends RequestBody {
    private MediaType contentType;
    private File file;
    private InputStream inputStream;
    private int buflength = 1024;
    private long mProgress;
    private long length;
    private ProgressRequestListener mListener;

    public ProgressRequestBody(MediaType contentType, File file) {
        this.contentType = contentType;
        this.file = file;
    }

    public ProgressRequestBody(MediaType contentType, File file, ProgressRequestListener mListener) {
        this.contentType = contentType;
        this.file = file;
        if (file != null) {
            this.length = file.length();
        }
        this.mListener = mListener;
    }

    public ProgressRequestBody(MediaType contentType, InputStream inputStream, long length, ProgressRequestListener mListener) {
        this.contentType = contentType;
        this.inputStream = inputStream;
        this.mListener = mListener;
        this.length = length;
    }

    public MediaType contentType() {
        return this.contentType;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        Source source = null;
        try {
            this.mProgress = 0L;
            if (this.file != null && this.file.exists()) {
                source = Okio.source((File)this.file);
            }
            if (this.inputStream != null) {
                source = Okio.source((InputStream)this.inputStream);
            }
            if (source != null) {
                Buffer buffer = new Buffer();
                long len = 0L;
                while ((len = source.read(buffer, (long)this.buflength)) != -1L) {
                    sink.write(buffer, len);
                    if (this.mListener == null) continue;
                    this.mProgress += len;
                    this.mListener.onRequestProgress(this.mProgress, this.contentLength(), this.mProgress == this.contentLength());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long contentLength() throws IOException {
        return this.length;
    }

    public static interface ProgressRequestListener {
        public void onRequestProgress(long var1, long var3, boolean var5);
    }
}

