/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin.base.network.request;

import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class ProgressResponseBody
extends ResponseBody {
    private final ResponseBody mResponseBody;
    private final ProgressResponseListener mListener;
    private BufferedSource mBufferedSource;

    public ProgressResponseBody(ResponseBody responseBody, ProgressResponseListener l) {
        this.mResponseBody = responseBody;
        this.mListener = l;
    }

    public MediaType contentType() {
        return this.mResponseBody.contentType();
    }

    public long contentLength() {
        return this.mResponseBody.contentLength();
    }

    public BufferedSource source() {
        if (this.mBufferedSource == null) {
            this.mBufferedSource = Okio.buffer((Source)this.source((Source)this.mResponseBody.source()));
        }
        return this.mBufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            long mProgress;
            {
                this.mProgress = 0L;
            }

            public long read(Buffer sink, long byteCount) throws IOException {
                long length = super.read(sink, byteCount);
                this.mProgress += length != -1L ? length : 0L;
                ProgressResponseBody.this.mListener.onResponseProgress(this.mProgress, ProgressResponseBody.this.mResponseBody.contentLength(), length == -1L);
                return length;
            }
        };
    }

    public static interface ProgressResponseListener {
        public void onResponseProgress(long var1, long var3, boolean var5);
    }
}

