/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin.base.utils;

import android.content.SharedPreferences;
import com.qihoo.livecloud.plugin.core.PluginConfig;

public class PreferenceManager {
    public static SharedPreferences getSharedPreferences() {
        return PluginConfig.getAppContext().getSharedPreferences("qhvc_plugin", 0);
    }

    public static void remove(String key) {
        SharedPreferences.Editor editor = PreferenceManager.getSharedPreferences().edit();
        editor.remove(key);
        editor.apply();
    }

    public static long getLong(String key, long defaultValue) {
        String str;
        SharedPreferences sp = PreferenceManager.getSharedPreferences();
        try {
            str = sp.getString(key, null);
        }
        catch (Exception e) {
            return sp.getLong(key, defaultValue);
        }
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static void setLong(String key, long value) {
        SharedPreferences.Editor editor = PreferenceManager.getSharedPreferences().edit();
        try {
            editor.putString(key, String.valueOf(value));
        }
        catch (Exception e) {
            editor.putLong(key, value);
        }
        editor.apply();
    }

    public static String getString(String key) {
        SharedPreferences sp = PreferenceManager.getSharedPreferences();
        return sp.getString(key, "");
    }

    public static void setString(String key, String value) {
        SharedPreferences.Editor editor = PreferenceManager.getSharedPreferences().edit();
        editor.putString(key, value);
        editor.apply();
    }
}

