/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin.core;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.qihoo.livecloud.tools.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PluginAbiHelper {
    private static String CURRENT_ABI = null;

    public static String getCurrentAbi(Context context) {
        return "armeabi-v7a";
    }

    public static String[] getSystemSupportAbis() {
        if (Build.VERSION.SDK_INT >= 21 && Build.SUPPORTED_ABIS.length > 0) {
            return Build.SUPPORTED_ABIS;
        }
        if (!TextUtils.isEmpty((CharSequence)Build.CPU_ABI2)) {
            return new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        }
        return new String[]{Build.CPU_ABI};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getApkSupportAbis(Context context) {
        block19: {
            HashSet<String> hashSet;
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(new File(context.getApplicationInfo().sourceDir), 1);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                if (entries == null) {
                    Logger.e("LiveCloudPlugin", "FATAL! Couldn't open application apk!");
                    Set<String> set = null;
                    return set;
                }
                HashSet<String> supportAbis = new HashSet<String>();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    if (zipEntry == null || !zipEntry.getName().startsWith("lib/")) continue;
                    String abi = zipEntry.getName().substring(4);
                    int end = abi.indexOf("/");
                    if (end > 0) {
                        abi = abi.substring(0, end);
                    }
                    supportAbis.add(abi);
                }
                for (String abi : supportAbis) {
                    Logger.d("LiveCloudPlugin", "Apk support abi: " + abi);
                }
                hashSet = supportAbis;
            }
            catch (Throwable e) {
                e.printStackTrace();
                Logger.e("LiveCloudPlugin", "FATAL! Couldn't find any abi!");
                break block19;
            }
            finally {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return hashSet;
        }
        return null;
    }
}

