/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin.core;

import android.text.TextUtils;
import com.qihoo.livecloud.plugin.ILiveCloudPlugin;
import com.qihoo.livecloud.plugin.base.network.HttpClient;
import com.qihoo.livecloud.plugin.base.network.HttpResponse;
import com.qihoo.livecloud.plugin.base.network.HttpUtils;
import com.qihoo.livecloud.plugin.base.network.request.JsonRequest;
import com.qihoo.livecloud.plugin.base.utils.ThreadUtils;
import com.qihoo.livecloud.plugin.core.PluginAbiHelper;
import com.qihoo.livecloud.plugin.core.PluginConfig;
import com.qihoo.livecloud.plugin.core.PluginRunningListener;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.MD5;
import com.qihoo.livecloud.tools.SoErrorReport;
import com.qihoo.livecloud.tools.URLSafeBase64;
import com.qihoo.livecloud.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PluginDownloadHelper {
    private static final int MIN_PLUGIN_SIZE = 1024;
    private static final int MAX_PLUGIN_SIZE = 0x3200000;
    private static final int PROGRESS_DOWNLOAD_MAX = 95;
    private static final int BUFFER_SIZE = 4096;

    public static String getDefaultPluginDir() {
        String packageName = PluginConfig.getAppContext().getPackageName();
        File path = PluginConfig.getAppContext().getFilesDir().getParentFile();
        if (path.getAbsolutePath().contains("/Plugin/" + packageName + "/data/" + packageName)) {
            path = path.getParentFile().getParentFile();
        }
        return new File(path, "lib").getAbsolutePath();
    }

    private static String getPluginDir() {
        String dir = PluginConfig.getAppContext().getFilesDir().getAbsolutePath() + File.separator + "plugin" + File.separator + PluginAbiHelper.getCurrentAbi(PluginConfig.getAppContext()) + File.separator;
        FileUtils.createDir(dir);
        return dir;
    }

    public static String getPluginDir(String plugin) {
        String dir = PluginDownloadHelper.getPluginDir() + plugin + File.separator;
        FileUtils.createDir(dir);
        return dir;
    }

    static String getPluginDir(String plugin, String version) {
        if (TextUtils.isEmpty((CharSequence)version)) {
            return PluginDownloadHelper.getPluginDir(plugin);
        }
        String dir = PluginDownloadHelper.getPluginDir() + plugin + "_" + version + File.separator;
        return dir;
    }

    static String getPluginTmpPath(String plugin, String version) {
        return PluginDownloadHelper.getPluginDir() + plugin + "_" + version + ".zip";
    }

    static String getPluginConfig(String plugin, String version, int retryCount) {
        String filename = String.format("android_plugin_%s_%s.cfg", plugin, version);
        String url = PluginConfig.URL_PLUGIN_CONFIG + URLSafeBase64.encodeToString(filename);
        if (retryCount >= PluginConfig.RETRY_COUNT_SWITCH_BACKUP) {
            url = url.replace(PluginConfig.URL_PLUGIN_CONFIG, PluginConfig.URL_BACKUP_PLUGIN_CONFIG);
        }
        return url;
    }

    static String getPluginDownloadUrl(String url, int retryCount) {
        if (retryCount >= PluginConfig.RETRY_COUNT_SWITCH_BACKUP) {
            url = url.replace(PluginConfig.URL_PLUGIN_CONFIG, PluginConfig.URL_BACKUP_PLUGIN_CONFIG);
        }
        return url;
    }

    static JSONObject downloadUpdateConfig(String plugin, String version, int retryCount) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("plugin", plugin);
        params.put("plugin_version", version);
        String url = HttpUtils.formatUrlByMethod(PluginDownloadHelper.getPluginConfig(plugin, version, retryCount), params);
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("retryCount", String.valueOf(retryCount));
        JsonRequest request = new JsonRequest(url, null);
        HttpResponse response = HttpClient.addRequestSync(request);
        if (response != null) {
            try {
                if (response.isSuccessful()) {
                    return new JSONObject(response.getString());
                }
                SoErrorReport.report("pluginDownloadConfig", response.getHttpStatusCode(), false, false, reportParams);
                return null;
            }
            catch (JSONException e) {
                SoErrorReport.report("pluginDownloadConfig", -1, false, false, reportParams);
            }
            catch (Throwable e) {
                Logger.e("LiveCloudPlugin", "plugin config parse failed, e=" + e.getMessage());
                SoErrorReport.report("pluginDownloadConfig", -2, false, false, reportParams);
            }
        } else {
            SoErrorReport.report("pluginDownloadConfig", -3, false, false, reportParams);
        }
        return null;
    }

    static UpdatePluginConfig parseUpdateConfig(JSONObject responseJson, String plugin, String version) {
        try {
            JSONObject dataJson = responseJson.getJSONObject("data");
            JSONObject configJson = dataJson.getJSONObject(PluginAbiHelper.getCurrentAbi(PluginConfig.getAppContext()));
            String url = configJson.getString("url").trim();
            String md5 = configJson.getString("md5");
            long size = configJson.optLong("size");
            int rate = 100;
            if (responseJson.has("rate")) {
                rate = configJson.optInt("rate");
            }
            ArrayList<String> files = new ArrayList<String>();
            JSONArray fileJsonArray = configJson.getJSONArray("files");
            for (int i = 0; i < fileJsonArray.length(); ++i) {
                String file = fileJsonArray.optString(i);
                if (TextUtils.isEmpty((CharSequence)file)) continue;
                files.add(file);
            }
            return new UpdatePluginConfig(url, md5, size, version, rate, files);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static boolean downloadPluginZip(File file, String url, long size, int retryCount, ILiveCloudPlugin.PluginDownloadListener downloadListener, PluginRunningListener runningListener) {
        if (downloadListener == null) {
            return PluginDownloadHelper.downloadPluginZip(file, url, retryCount, runningListener);
        }
        return PluginDownloadHelper.downloadPluginZipByCustom(file, url, size, retryCount, downloadListener, runningListener);
    }

    /*
     * Exception decompiling
     */
    private static boolean downloadPluginZip(File file, String url, int retryCount, PluginRunningListener listener) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean downloadPluginZipByCustom(final File file, final String url, final long size, int retryCount, final ILiveCloudPlugin.PluginDownloadListener downloadListener, final PluginRunningListener runningListener) {
        int RET_UNKNOWN = -1;
        boolean RET_SUCCESS = false;
        boolean RET_FAILED = true;
        int RET_CANCEL = 2;
        int RET_CANCEL_DOWNLOAD_BY_SYSTEM = 3;
        final Object obj = new Object();
        final int[] ret = new int[]{-1};
        Logger.d("LiveCloudPlugin", "(%s) plugin downloadPluginZipByCustom before call", ThreadUtils.getCurThreadName());
        new Thread(new Runnable(){

            @Override
            public void run() {
                Logger.d("LiveCloudPlugin", "(%s) plugin downloadPluginZipByCustom start thread", ThreadUtils.getCurThreadName());
                if (runningListener.isCancelled()) {
                    Logger.d("LiveCloudPlugin", "(%s) plugin downloadPluginZipByCustom cancel thread", ThreadUtils.getCurThreadName());
                    return;
                }
                downloadListener.onDownload(file, url, size, new ILiveCloudPlugin.PluginDownloadCallback(){

                    @Override
                    public boolean isCancelled() {
                        return runningListener.isCancelled();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onProgress(int progress) {
                        Logger.d("LiveCloudPlugin", "(%s) plugin downloadPluginZipByCustom onProgress=%d", ThreadUtils.getCurThreadName(), progress);
                        if (progress < 0) {
                            progress = 0;
                        } else if (progress > 100) {
                            progress = 100;
                        }
                        runningListener.onProgress(progress * 95 / 100);
                        Object object = obj;
                        synchronized (object) {
                            obj.notify();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onCancel(boolean downloadWithSystem) {
                        Logger.d("LiveCloudPlugin", "(%s) plugin downloadPluginZipByCustom cancel", ThreadUtils.getCurThreadName());
                        Object object = obj;
                        synchronized (object) {
                            ret[0] = downloadWithSystem ? 3 : 2;
                            obj.notify();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onSuccess() {
                        Logger.d("LiveCloudPlugin", "(%s) plugin downloadPluginZipByCustom success", ThreadUtils.getCurThreadName());
                        Object object = obj;
                        synchronized (object) {
                            ret[0] = 0;
                            obj.notify();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailed() {
                        Logger.d("LiveCloudPlugin", "(%s) plugin downloadPluginZipByCustom failed", ThreadUtils.getCurThreadName());
                        Object object = obj;
                        synchronized (object) {
                            ret[0] = 1;
                            obj.notify();
                        }
                    }
                });
            }
        }).start();
        Logger.d("LiveCloudPlugin", "(%s) plugin downloadPluginZipByCustom after call", ThreadUtils.getCurThreadName());
        Object object = obj;
        synchronized (object) {
            while (ret[0] == -1 && !runningListener.isCancelled()) {
                Logger.d("LiveCloudPlugin", "(%s) plugin downloadPluginZipByCustom before wait", ThreadUtils.getCurThreadName());
                try {
                    obj.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Logger.d("LiveCloudPlugin", "(%s) plugin downloadPluginZipByCustom after wait", ThreadUtils.getCurThreadName());
            }
        }
        Logger.d("LiveCloudPlugin", "(%s) plugin downloadPluginZipByCustom end ret=" + ret[0], ThreadUtils.getCurThreadName());
        if (ret[0] == 3) {
            Logger.d("LiveCloudPlugin", "(%s) plugin downloadPluginZipByCustom cancel, download by system", ThreadUtils.getCurThreadName());
            ret[0] = PluginDownloadHelper.downloadPluginZip(file, url, retryCount, runningListener) ? 0 : 1;
        }
        return ret[0] == 0;
    }

    private static int calcDownloadProcess(long length, long download) {
        if (length <= 0L) {
            return 1;
        }
        return (int)(download * 95L / length);
    }

    private static void close(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void close(OutputStream output) {
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static boolean checkFileMd5Same(String path, String newMd5) {
        boolean bret = false;
        try {
            String md5 = MD5.encryptMD5(new File(path));
            if (newMd5.equalsIgnoreCase(md5)) {
                bret = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bret;
    }

    static boolean deleteDir(String path) {
        boolean isDelete = false;
        File file = new File(path);
        if (file.exists()) {
            if (file.isDirectory()) {
                isDelete = PluginDownloadHelper.deleteRecursive(file);
            }
        } else {
            isDelete = true;
        }
        return isDelete;
    }

    private static boolean deleteRecursive(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            for (File child : fileOrDirectory.listFiles()) {
                PluginDownloadHelper.deleteRecursive(child);
            }
        }
        return fileOrDirectory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean unzipPluginFile(PluginRunningListener listener, String path, String location, List<String> files) {
        boolean bl;
        int progress = 95;
        listener.onProgress(progress);
        File zipFile = new File(path);
        File targetDir = new File(location);
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        FileInputStream fin = null;
        ZipInputStream zin = null;
        FileOutputStream fout = null;
        byte[] data = new byte[4096];
        try {
            fin = new FileInputStream(zipFile);
            zin = new ZipInputStream(fin);
            ZipEntry ze = zin.getNextEntry();
            while (ze != null) {
                String name = ze.getName();
                if (name != null && name.contains("../")) continue;
                if (ze.isDirectory()) {
                    File f = new File(location + ze.getName());
                    if (!f.exists()) {
                        Logger.d("LiveCloudPlugin", "unzip dir name is " + location + ze.getName());
                        f.mkdirs();
                    }
                } else {
                    int count;
                    File tmpFile = new File(location + ze.getName() + ".tmp");
                    if (tmpFile.exists()) {
                        tmpFile.delete();
                    }
                    fout = new FileOutputStream(tmpFile.getAbsolutePath());
                    Logger.d("LiveCloudPlugin", "unzip file name is " + location + ze.getName());
                    while ((count = zin.read(data, 0, 4096)) != -1) {
                        fout.write(data, 0, count);
                    }
                    fout.flush();
                    fout.close();
                    fout = null;
                    zin.closeEntry();
                    File finalFile = new File(location + ze.getName());
                    if (finalFile.exists()) {
                        finalFile.delete();
                    }
                    if (!tmpFile.renameTo(finalFile)) {
                        throw new IOException("rename failed");
                    }
                    files.add(finalFile.getAbsolutePath().substring(location.length()));
                    listener.onProgress(++progress < 100 ? progress : 99);
                }
                ze = zin.getNextEntry();
            }
            bl = true;
        }
        catch (Exception e) {
            try {
                Logger.e("LiveCloudPlugin", "Unzip player plugin file, " + e.getMessage());
            }
            catch (Throwable throwable) {
                PluginDownloadHelper.close(fin);
                PluginDownloadHelper.close(zin);
                PluginDownloadHelper.close(fout);
                throw throwable;
            }
            PluginDownloadHelper.close(fin);
            PluginDownloadHelper.close(zin);
            PluginDownloadHelper.close(fout);
            return false;
        }
        PluginDownloadHelper.close(fin);
        PluginDownloadHelper.close(zin);
        PluginDownloadHelper.close(fout);
        return bl;
    }

    static boolean checkZipFilesSame(List<String> zip, List<String> config) {
        if (zip == null && config == null) {
            return true;
        }
        if (zip == null || config == null) {
            return false;
        }
        for (String c : config) {
            if (zip.indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }

    static boolean deleteFile(File file) {
        boolean isDelete = false;
        if (file.exists()) {
            if (file.isFile()) {
                isDelete = file.delete();
            }
        } else {
            isDelete = true;
        }
        return isDelete;
    }

    static class UpdatePluginConfig {
        public String url;
        public String md5;
        public long size;
        public String version;
        public int rate;
        public List<String> files;

        public UpdatePluginConfig(String url, String md5, long size, String version, int rate, List<String> files) {
            this.url = url;
            this.md5 = md5;
            this.size = size;
            this.version = version;
            this.rate = rate;
            this.files = files;
        }
    }
}

