/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin.core;

import android.content.Context;
import android.os.Build;
import com.qihoo.livecloud.plugin.base.utils.ShareReflectUtil;
import com.qihoo.livecloud.tools.Logger;
import dalvik.system.BaseDexClassLoader;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

class PluginNativeHelper {
    PluginNativeHelper() {
    }

    static void addNativeDirectory(Context context, String dir) throws Throwable {
        BaseDexClassLoader classLoader = (BaseDexClassLoader)context.getClassLoader();
        File folder = new File(dir);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (Build.VERSION.SDK_INT >= 25) {
            try {
                V25.install((ClassLoader)classLoader, folder);
            }
            catch (Throwable throwable) {
                Logger.e("LiveCloudPlugin", "installNativeLibraryPath, v25 fail, sdk: " + Build.VERSION.SDK_INT + ", error: " + throwable + ", try to fallback to V23");
                V23.install((ClassLoader)classLoader, folder);
            }
        } else if (Build.VERSION.SDK_INT >= 23) {
            try {
                V23.install((ClassLoader)classLoader, folder);
            }
            catch (Throwable throwable) {
                Logger.e("LiveCloudPlugin", "installNativeLibraryPath, v23 fail, sdk: " + Build.VERSION.SDK_INT + ", error: " + throwable + ", try to fallback to V14");
                V14.install((ClassLoader)classLoader, folder);
            }
        } else if (Build.VERSION.SDK_INT >= 14) {
            V14.install((ClassLoader)classLoader, folder);
        } else {
            V4.install((ClassLoader)classLoader, folder);
        }
    }

    private static void addList(List<File> list, File file) {
        if (list == null || file == null) {
            return;
        }
        boolean find = false;
        for (File temp : list) {
            if (!temp.getAbsolutePath().equals(file.getAbsolutePath())) continue;
            find = true;
            break;
        }
        if (!find) {
            list.add(0, file);
        }
    }

    private static final class V25 {
        private V25() {
        }

        private static void install(ClassLoader classLoader, File folder) throws Throwable {
            Field pathListField = ShareReflectUtil.findField(classLoader, "pathList");
            Object dexPathList = pathListField.get(classLoader);
            Field nativeLibraryDirectories = ShareReflectUtil.findField(dexPathList, "nativeLibraryDirectories");
            List libDirs = (List)nativeLibraryDirectories.get(dexPathList);
            PluginNativeHelper.addList(libDirs, folder);
            Field systemNativeLibraryDirectories = ShareReflectUtil.findField(dexPathList, "systemNativeLibraryDirectories");
            List systemLibDirs = (List)systemNativeLibraryDirectories.get(dexPathList);
            Method makePathElements = ShareReflectUtil.findMethod(dexPathList, "makePathElements", List.class);
            libDirs.addAll(systemLibDirs);
            Object[] elements = (Object[])makePathElements.invoke(dexPathList, libDirs);
            Field nativeLibraryPathElements = ShareReflectUtil.findField(dexPathList, "nativeLibraryPathElements");
            nativeLibraryPathElements.setAccessible(true);
            nativeLibraryPathElements.set(dexPathList, elements);
        }
    }

    private static final class V23 {
        private V23() {
        }

        private static void install(ClassLoader classLoader, File folder) throws Throwable {
            Field pathListField = ShareReflectUtil.findField(classLoader, "pathList");
            Object dexPathList = pathListField.get(classLoader);
            Field nativeLibraryDirectories = ShareReflectUtil.findField(dexPathList, "nativeLibraryDirectories");
            List libDirs = (List)nativeLibraryDirectories.get(dexPathList);
            PluginNativeHelper.addList(libDirs, folder);
            Field systemNativeLibraryDirectories = ShareReflectUtil.findField(dexPathList, "systemNativeLibraryDirectories");
            List systemLibDirs = (List)systemNativeLibraryDirectories.get(dexPathList);
            Method makePathElements = ShareReflectUtil.findMethod(dexPathList, "makePathElements", List.class, File.class, List.class);
            ArrayList suppressedExceptions = new ArrayList();
            libDirs.addAll(systemLibDirs);
            Object[] elements = (Object[])makePathElements.invoke(dexPathList, libDirs, null, suppressedExceptions);
            Field nativeLibraryPathElements = ShareReflectUtil.findField(dexPathList, "nativeLibraryPathElements");
            nativeLibraryPathElements.setAccessible(true);
            nativeLibraryPathElements.set(dexPathList, elements);
        }
    }

    private static final class V14 {
        private V14() {
        }

        private static void install(ClassLoader classLoader, File folder) throws Throwable {
            Field pathListField = ShareReflectUtil.findField(classLoader, "pathList");
            Object dexPathList = pathListField.get(classLoader);
            ShareReflectUtil.expandFieldArray(dexPathList, "nativeLibraryDirectories", new File[]{folder});
        }
    }

    private static final class V4 {
        private V4() {
        }

        private static void install(ClassLoader classLoader, File folder) throws Throwable {
            String addPath = folder.getPath();
            Field pathField = ShareReflectUtil.findField(classLoader, "libPath");
            StringBuilder libPath = new StringBuilder((String)pathField.get(classLoader));
            libPath.append(':').append(addPath);
            pathField.set(classLoader, libPath.toString());
            Field libraryPathElementsFiled = ShareReflectUtil.findField(classLoader, "libraryPathElements");
            List libraryPathElements = (List)libraryPathElementsFiled.get(classLoader);
            libraryPathElements.add(0, addPath);
            libraryPathElementsFiled.set(classLoader, libraryPathElements);
        }
    }
}

