/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.plugin.core;

import android.annotation.SuppressLint;
import android.os.Build;
import android.text.TextUtils;
import com.qihoo.livecloud.plugin.ILiveCloudPlugin;
import com.qihoo.livecloud.plugin.base.utils.PreferenceManager;
import com.qihoo.livecloud.plugin.core.PluginAbiHelper;
import com.qihoo.livecloud.plugin.core.PluginConfig;
import com.qihoo.livecloud.plugin.core.PluginDownloadHelper;
import com.qihoo.livecloud.plugin.core.PluginNativeHelper;
import com.qihoo.livecloud.plugin.core.PluginRunningListener;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.utils.DiskUtils;
import com.qihoo.livecloud.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class PluginUpdateHelper {
    private static final long CHECK_UPDATE_INTERVAL = 3600000L;
    private static final String PREF_PRE = "plugin.";
    private static final String PREF_PLUGIN_UPDATE_TIME = ".update_time";
    private static final String PREF_PLUGIN_MD5 = ".md5";
    private static final String PREF_PLUGIN_VERSION = ".version";
    private static final String PREF_PLUGIN_FILES = ".files";
    private static Map<String, Boolean> sDefaultPluginInstalled = new HashMap<String, Boolean>();
    private static Map<String, Boolean> sPluginInstalled = new HashMap<String, Boolean>();
    private static Map<String, Boolean> sPluginLoaded = new HashMap<String, Boolean>();

    public static void setDefaultPluginInstalled(String plugin, boolean defaultPluginInstalled) {
        sDefaultPluginInstalled.put(plugin, defaultPluginInstalled);
    }

    public static boolean isDefaultPluginInstalled(String plugin) {
        if (sDefaultPluginInstalled.containsKey(plugin)) {
            return sDefaultPluginInstalled.get(plugin);
        }
        return true;
    }

    public static boolean isPluginInstalled(String plugin, String version) {
        String key = plugin + (TextUtils.isEmpty((CharSequence)version) ? "" : "_" + version);
        if (sPluginInstalled.containsKey(key) && sPluginInstalled.get(key).booleanValue()) {
            return true;
        }
        List<String> files = PluginUpdateHelper.getPluginFiles(plugin, version);
        if (files == null || files.size() == 0) {
            return false;
        }
        for (String file : files) {
            if (new File(file).exists()) continue;
            return false;
        }
        sPluginInstalled.put(key, true);
        return true;
    }

    private static void setPluginInstalled(String plugin, String version, boolean installed) {
        String key = plugin + (TextUtils.isEmpty((CharSequence)version) ? "" : "_" + version);
        sPluginInstalled.remove(key);
    }

    @SuppressLint(value={"UnsafeDynamicallyLoadedCode"})
    public static int loadPlugin(String plugin) {
        if (PluginUpdateHelper.isPluginLoaded(plugin)) {
            return 0;
        }
        if (!PluginUpdateHelper.isPluginInstalled(plugin, null)) {
            return 2;
        }
        Logger.i("LiveCloudPlugin", "try load plugin " + plugin + ", version=" + PluginUpdateHelper.getPluginVersion(plugin));
        List<String> files = PluginUpdateHelper.getPluginFiles(plugin, null);
        if (files == null || files.size() == 0) {
            return 2;
        }
        try {
            PluginNativeHelper.addNativeDirectory(PluginConfig.getAppContext(), PluginDownloadHelper.getPluginDir(plugin));
            for (String file : files) {
                try {
                    System.load(file);
                }
                catch (Throwable e) {
                    Logger.e("LiveCloudPlugin", "prepare load plugin " + plugin + " failed,\n " + e.getMessage());
                }
            }
            for (String file : files) {
                System.load(file);
            }
            PluginUpdateHelper.setPluginLoaded(plugin, true);
            return 0;
        }
        catch (Throwable e) {
            Logger.e("LiveCloudPlugin", "load plugin " + plugin + " failed,\n " + e.getMessage());
            return 11;
        }
    }

    public static boolean isPluginLoaded(String plugin) {
        if (sPluginLoaded.containsKey(plugin)) {
            return sPluginLoaded.get(plugin);
        }
        return false;
    }

    private static void setPluginLoaded(String plugin, boolean loaded) {
        sPluginLoaded.put(plugin, loaded);
    }

    private static List<String> getPluginFiles(String plugin, String version) {
        String files = PreferenceManager.getString(PluginUpdateHelper.genPrefKey(plugin, version, PREF_PLUGIN_FILES));
        if (TextUtils.isEmpty((CharSequence)files)) {
            return null;
        }
        String path = PluginDownloadHelper.getPluginDir(plugin, version);
        ArrayList<String> ret = new ArrayList<String>();
        for (String file : files.split(",")) {
            ret.add(path + file);
        }
        return ret;
    }

    public static String getPluginVersion(String plugin) {
        return PreferenceManager.getString(PluginUpdateHelper.genPrefKey(plugin, PREF_PLUGIN_VERSION));
    }

    public static int checkInstallOrUpdatePlugin(String plugin, String version, int type, int retryCount, ILiveCloudPlugin.PluginDownloadListener downloadListener, PluginRunningListener runningListener) {
        String tmpVersion = type == 0 ? null : version;
        String path = PluginDownloadHelper.getPluginDir(plugin, tmpVersion);
        if (PluginUpdateHelper.isDefaultPluginInstalled(plugin)) {
            return 0;
        }
        if (!PluginUpdateHelper.isPluginInstalled(plugin, tmpVersion)) {
            PluginUpdateHelper.clearPluginConfig(plugin, tmpVersion);
            if (type == 1 && PluginUpdateHelper.isPluginInstalled(plugin, null) && version.compareTo(PluginUpdateHelper.getPluginVersion(plugin)) == 0 && System.currentTimeMillis() - PreferenceManager.getLong(PluginUpdateHelper.genPrefKey(plugin, null, PREF_PLUGIN_UPDATE_TIME), 0L) < 3600000L) {
                return 0;
            }
        } else if (System.currentTimeMillis() - PreferenceManager.getLong(PluginUpdateHelper.genPrefKey(plugin, tmpVersion, PREF_PLUGIN_UPDATE_TIME), 0L) < 3600000L) {
            return 0;
        }
        if (runningListener.isCancelled()) {
            return 1;
        }
        long freeSpace = DiskUtils.getFreeSpaces(PluginConfig.getAppContext().getFilesDir().getAbsolutePath());
        if (freeSpace != -1L && freeSpace < 0xA00000L) {
            return 3;
        }
        JSONObject configJson = PluginDownloadHelper.downloadUpdateConfig(plugin, version, retryCount);
        if (configJson == null) {
            return 4;
        }
        PluginDownloadHelper.UpdatePluginConfig config = PluginDownloadHelper.parseUpdateConfig(configJson, plugin, version);
        if (config == null) {
            return 5;
        }
        if (runningListener.isCancelled()) {
            return 1;
        }
        String oldMd5 = PreferenceManager.getString(PluginUpdateHelper.genPrefKey(plugin, tmpVersion, PREF_PLUGIN_MD5));
        if (type == 1 && PluginUpdateHelper.isPluginInstalled(plugin, null) && version.compareTo(PluginUpdateHelper.getPluginVersion(plugin)) == 0) {
            oldMd5 = PreferenceManager.getString(PluginUpdateHelper.genPrefKey(plugin, null, PREF_PLUGIN_MD5));
        }
        if (!oldMd5.isEmpty() && oldMd5.equalsIgnoreCase(config.md5)) {
            return 0;
        }
        FileUtils.createDir(path);
        runningListener.onProgress(0);
        File zipFile = new File(PluginDownloadHelper.getPluginTmpPath(plugin, version));
        String url = PluginDownloadHelper.getPluginDownloadUrl(config.url, retryCount);
        Logger.d("LiveCloudPlugin", "download plugin url=" + url + ", file=" + zipFile.getAbsolutePath());
        boolean ret = PluginDownloadHelper.downloadPluginZip(zipFile, url, config.size, retryCount, downloadListener, runningListener);
        if (!ret) {
            return 6;
        }
        if (runningListener.isCancelled()) {
            return 1;
        }
        if (!PluginDownloadHelper.checkFileMd5Same(zipFile.getAbsolutePath(), config.md5)) {
            return 7;
        }
        if (runningListener.isCancelled()) {
            return 1;
        }
        if (!PluginDownloadHelper.deleteDir(path)) {
            return 10;
        }
        ArrayList<String> files = new ArrayList<String>();
        if (!PluginDownloadHelper.unzipPluginFile(runningListener, zipFile.getAbsolutePath(), path, files)) {
            return 8;
        }
        if (!PluginDownloadHelper.checkZipFilesSame(files, config.files)) {
            return 9;
        }
        PluginDownloadHelper.deleteFile(zipFile);
        runningListener.onProgress(100);
        boolean x86 = false;
        String cpu = Build.CPU_ABI;
        if (cpu != null) {
            x86 = cpu.toLowerCase().contains("x86");
        }
        if (x86) {
            int index = -1;
            for (int i = 0; i < config.files.size(); ++i) {
                if (!config.files.get(i).contains("libmyssl.so")) continue;
                index = i;
                break;
            }
            if (index != -1) {
                String fileSSL = config.files.get(index);
                config.files.remove(index);
                new File(path, fileSSL).delete();
            }
        }
        StringBuilder buf = new StringBuilder();
        for (String file : config.files) {
            buf.append(file).append(",");
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        PreferenceManager.setString(PluginUpdateHelper.genPrefKey(plugin, tmpVersion, PREF_PLUGIN_FILES), buf.toString());
        PreferenceManager.setString(PluginUpdateHelper.genPrefKey(plugin, tmpVersion, PREF_PLUGIN_MD5), config.md5);
        PreferenceManager.setString(PluginUpdateHelper.genPrefKey(plugin, tmpVersion, PREF_PLUGIN_VERSION), config.version);
        PreferenceManager.setLong(PluginUpdateHelper.genPrefKey(plugin, tmpVersion, PREF_PLUGIN_UPDATE_TIME), System.currentTimeMillis());
        return 0;
    }

    public static void clearPluginConfig(String plugin, String version) {
        PreferenceManager.remove(PluginUpdateHelper.genPrefKey(plugin, version, PREF_PLUGIN_FILES));
        PreferenceManager.remove(PluginUpdateHelper.genPrefKey(plugin, version, PREF_PLUGIN_MD5));
        PreferenceManager.remove(PluginUpdateHelper.genPrefKey(plugin, version, PREF_PLUGIN_VERSION));
        PreferenceManager.remove(PluginUpdateHelper.genPrefKey(plugin, version, PREF_PLUGIN_UPDATE_TIME));
    }

    public static int removePlugin(String plugin, String version) {
        if (!PluginUpdateHelper.isPluginInstalled(plugin, version)) {
            return 0;
        }
        PluginUpdateHelper.setPluginInstalled(plugin, version, false);
        if (TextUtils.isEmpty((CharSequence)version)) {
            PluginUpdateHelper.setPluginLoaded(plugin, false);
        }
        PluginUpdateHelper.clearPluginConfig(plugin, version);
        File srcFile = new File(PluginDownloadHelper.getPluginDir(plugin, version));
        final File dstFile = new File(srcFile.getAbsolutePath() + "_del");
        if (!srcFile.renameTo(dstFile)) {
            return 10;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                PluginDownloadHelper.deleteDir(dstFile.getAbsolutePath());
            }
        }).start();
        return 0;
    }

    public static int updatePlugin(String plugin, String newVersion) {
        PluginUpdateHelper.removePlugin(plugin, null);
        String oldPath = PluginDownloadHelper.getPluginDir(plugin);
        String newPath = PluginDownloadHelper.getPluginDir(plugin, newVersion);
        if (!new File(newPath).renameTo(new File(oldPath))) {
            return 16;
        }
        PreferenceManager.setString(PluginUpdateHelper.genPrefKey(plugin, null, PREF_PLUGIN_FILES), PreferenceManager.getString(PluginUpdateHelper.genPrefKey(plugin, newVersion, PREF_PLUGIN_FILES)));
        PreferenceManager.setString(PluginUpdateHelper.genPrefKey(plugin, null, PREF_PLUGIN_MD5), PreferenceManager.getString(PluginUpdateHelper.genPrefKey(plugin, newVersion, PREF_PLUGIN_MD5)));
        PreferenceManager.setString(PluginUpdateHelper.genPrefKey(plugin, null, PREF_PLUGIN_VERSION), PreferenceManager.getString(PluginUpdateHelper.genPrefKey(plugin, newVersion, PREF_PLUGIN_VERSION)));
        PreferenceManager.setLong(PluginUpdateHelper.genPrefKey(plugin, null, PREF_PLUGIN_UPDATE_TIME), System.currentTimeMillis());
        PluginUpdateHelper.removePlugin(plugin, newVersion);
        return 0;
    }

    private static String genPrefKey(String tag, String key) {
        return PREF_PRE + PluginAbiHelper.getCurrentAbi(PluginConfig.getAppContext()) + "." + tag + key;
    }

    private static String genPrefKey(String tag1, String tag2, String key) {
        return PREF_PRE + PluginAbiHelper.getCurrentAbi(PluginConfig.getAppContext()) + "." + (tag1 != null ? tag1 : "") + (tag2 != null ? "." + tag2 : "") + key;
    }
}

