/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.sdk;

import android.content.Context;
import android.net.NetworkInfo;
import android.text.TextUtils;
import com.qihoo.livecloud.network.NetworkStateMonitor;
import com.qihoo.livecloud.plugin.core.PluginConfig;
import com.qihoo.livecloud.sdk.DebugUtils;
import com.qihoo.livecloud.sdk.QHVCSdkConfig;
import com.qihoo.livecloud.tools.LocalSoLoadManager;
import com.qihoo.livecloud.tools.LogEntry;
import com.qihoo.livecloud.tools.LogPrintCallBack;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.RunnableManager;
import com.qihoo.livecloud.tools.Stats;
import com.qihoo.livecloud.tools.Version;

public class QHVCSdk {
    private static final String TAG = QHVCSdk.class.getSimpleName();
    private Context context;
    private QHVCSdkConfig config;
    private static volatile QHVCSdk instance;
    private static final String ERROR_INIT_CONFIG_WITH_NULL = "QHVCSdk configuration can not be initialized with null";
    private NetworkStateMonitor.NetworkChangeListener mNetworkChangeListener = new NetworkStateMonitor.NetworkChangeListener(){
        private int mLastNetworkType = 0;

        @Override
        public void onNetworkChange(NetworkInfo networkInfo, String networkType) {
            Logger.d(TAG, "onNetworkChange type= " + networkType);
            if (QHVCSdk.this.config != null) {
                QHVCSdk.this.config.setNetworkType(networkType);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QHVCSdk getInstance() {
        if (instance != null) return instance;
        Class<QHVCSdk> clazz = QHVCSdk.class;
        synchronized (QHVCSdk.class) {
            if (instance != null) return instance;
            instance = new QHVCSdk();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected QHVCSdk() {
    }

    public synchronized void init(QHVCSdkConfig config) {
        if (config == null || TextUtils.isEmpty((CharSequence)config.getBusinessId()) || TextUtils.isEmpty((CharSequence)config.getAppVersion()) || TextUtils.isEmpty((CharSequence)config.getMachineId())) {
            throw new IllegalArgumentException(ERROR_INIT_CONFIG_WITH_NULL);
        }
        this.context = config.getContext().getApplicationContext();
        this.config = config;
        PluginConfig.init(this.context);
        LocalSoLoadManager.getInstance().init(config.getContext());
        this.logInit();
        Logger.iif(LogEntry.logGetTransportId(), TAG, "config: " + config.toString());
        NetworkStateMonitor.getInstance().registerNetworkChangeListener(config.getContext(), this.mNetworkChangeListener);
        Stats.coreOnAppStart(config.getContext(), config.getBusinessId(), config.getAppVersion(), config.getMachineId(), config.getControlUrl());
    }

    public synchronized void destroy() {
        if (this.config != null) {
            NetworkStateMonitor.getInstance().unRegisterNetworkChangeListener(this.config.getContext(), this.mNetworkChangeListener);
        }
    }

    private void logInit() {
        DebugUtils debugUtils = this.config.getDebugUtils();
        if (debugUtils != null && debugUtils.isWriteLogs()) {
            Logger.enable();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Logger.i(TAG, "logInit: runnable run");
                DebugUtils debugUtils = QHVCSdk.this.config.getDebugUtils();
                if (debugUtils != null && debugUtils.isWriteLogs()) {
                    if (QHVCSdk.this.config != null) {
                        LogEntry.logStart(QHVCSdk.this.config.getContext());
                        LogEntry.logSetLogLevel(LogEntry.logGetTransportId(), debugUtils.getTransportLogLevel());
                        LogEntry.logSetLogLevel(LogEntry.logGetPlayerId(), debugUtils.getPlayerLogLevel());
                        LogEntry.logSetLogCb(new LogPrintCallBack(){

                            @Override
                            public void logPrint(int loggerID, int level, String data) {
                                switch (level) {
                                    case 0: {
                                        Logger.v("LiveCloud", data);
                                        break;
                                    }
                                    case 1: {
                                        Logger.d("LiveCloud", data);
                                        break;
                                    }
                                    case 2: {
                                        Logger.i("LiveCloud", data);
                                        break;
                                    }
                                    case 3: {
                                        Logger.w("LiveCloud", data);
                                        break;
                                    }
                                    case 4: 
                                    case 5: 
                                    case 6: {
                                        Logger.e("LiveCloud", data);
                                        break;
                                    }
                                    default: {
                                        Logger.d("LiveCloud", data);
                                    }
                                }
                            }
                        });
                    } else {
                        Logger.e(TAG, TAG + ", logInit failed, config is null....");
                    }
                }
            }
        };
        if (Stats.isSoLoaded()) {
            runnable.run();
        } else {
            Logger.i(TAG, "logInit: no so");
            RunnableManager.getInstance().addRunnable(runnable);
        }
    }

    public QHVCSdkConfig getConfig() {
        return this.config;
    }

    public String getVersion() {
        return Version.getPubLibVersion();
    }
}

