/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.sdk;

import android.content.Context;
import android.os.Build;
import com.qihoo.livecloud.sdk.DebugUtils;
import com.qihoo.livecloud.sdk.QHVCServerAddress;
import com.qihoo.livecloud.tools.DeviceIDUtils;
import com.qihoo.livecloud.tools.NetUtil;

public class QHVCSdkConfig {
    private Context context;
    private String businessId;
    private String appVersion;
    private String machineId;
    private String systemVersion;
    private String networkType;
    private String userId;
    private QHVCServerAddress serverAddress;
    private DebugUtils debugUtils;

    public static QHVCSdkConfig createDefault(Context context) {
        return new Builder(context).build();
    }

    public QHVCSdkConfig(Builder builder) {
        this.context = builder.context;
        this.businessId = builder.businessId;
        this.appVersion = builder.appVersion;
        this.machineId = builder.machineId;
        this.systemVersion = builder.systemVersion;
        this.networkType = builder.networkType;
        this.userId = builder.userId;
        this.debugUtils = builder.debugUtils;
        this.serverAddress = builder.serverAddress;
    }

    public Context getContext() {
        return this.context;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public String getUserId() {
        return this.userId;
    }

    public DebugUtils getDebugUtils() {
        return this.debugUtils;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public String getScheduleUrl() {
        return this.serverAddress != null ? this.serverAddress.getSchedule() : "";
    }

    public String getStatUrl() {
        return this.serverAddress != null ? this.serverAddress.getStat() : "";
    }

    public String getMergeUrl() {
        return this.serverAddress != null ? this.serverAddress.getMerge() : "";
    }

    public String getMicUrl() {
        return this.serverAddress != null ? this.serverAddress.getMic() : "";
    }

    public String getFeedbackUrl() {
        return this.serverAddress != null ? this.serverAddress.getFeedback() : "";
    }

    public String getControlUrl() {
        return this.serverAddress != null ? this.serverAddress.getControl() : "";
    }

    public String toString() {
        return "QHVCSdkConfig{businessId='" + this.businessId + '\'' + ", appVersion='" + this.appVersion + '\'' + ", machineId='" + this.machineId + '\'' + ", systemVersion='" + this.systemVersion + '\'' + ", networkType='" + this.networkType + '\'' + ", userId='" + this.userId + '\'' + ", serverAddress=" + this.serverAddress + ", debugUtils=" + this.debugUtils + '}';
    }

    public static class Builder {
        private static final String DEFAULT_BUSINESS_ID = "huajiao";
        private static final String DEFAULT_APP_VERSION = "0.0";
        private static final String DEFAULT_USER_ID = "QHVCDefaultUser";
        private static final String scheduleUrl = "http://g2.live.360.cn/";
        private static final String statUrl = "http://qos.live.360.cn/vc.gif";
        private static final String mergeUrl = "http://fb.live.360.cn/meg.gif";
        private static final String micUrl = "http://fb.live.360.cn/mic.gif";
        private static final String feedbackUrl = "http://fb.live.360.cn/fb.gif";
        private static final String controlUrl = "http://sdk.live.360.cn/";
        private Context context;
        private String businessId;
        private String appVersion;
        private String machineId;
        private String systemVersion = Build.VERSION.RELEASE;
        private String networkType;
        private String userId;
        private QHVCServerAddress serverAddress;
        private DebugUtils debugUtils;

        public Builder(Context context) {
            this.context = context.getApplicationContext();
        }

        public Builder setBusinessId(String businessId) {
            this.businessId = businessId;
            return this;
        }

        public Builder setServerAddress(QHVCServerAddress serverAddress) {
            this.serverAddress = serverAddress;
            return this;
        }

        public Builder setAppVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public Builder setMachineId(String machineId) {
            this.machineId = machineId;
            return this;
        }

        public Builder setSystemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
            return this;
        }

        public Builder setNetworkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public Builder setUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder setDebugUtils(DebugUtils debugUtils) {
            this.debugUtils = debugUtils;
            return this;
        }

        private void initEmptyFieldsWithDefaultValues() {
            if (this.businessId == null) {
                this.businessId = DEFAULT_BUSINESS_ID;
            }
            if (this.appVersion == null) {
                this.appVersion = DEFAULT_APP_VERSION;
            }
            if (this.machineId == null) {
                this.machineId = DeviceIDUtils.getIMEI2(this.context);
            }
            if (this.networkType == null) {
                this.networkType = NetUtil.getNetworkTypeName(this.context);
            }
            if (this.userId == null) {
                this.userId = DEFAULT_USER_ID;
            }
            if (this.serverAddress == null) {
                this.serverAddress = new QHVCServerAddress(scheduleUrl, statUrl, mergeUrl, micUrl, feedbackUrl, controlUrl);
            }
        }

        public QHVCSdkConfig build() {
            this.initEmptyFieldsWithDefaultValues();
            return new QHVCSdkConfig(this);
        }
    }
}

