/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.settings;

import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.gpsoft.decipher.GPDecipher;
import com.qihoo.livecloud.network.HttpByteCallBack;
import com.qihoo.livecloud.network.HttpCallBack;
import com.qihoo.livecloud.network.LCHttpGet;
import com.qihoo.livecloud.network.LCHttpGetByte;
import com.qihoo.livecloud.network.LiveCloudHttpParam;
import com.qihoo.livecloud.tools.GPThreadTools;
import com.qihoo.livecloud.tools.LocalSoLoadManager;
import com.qihoo.livecloud.tools.MD5;
import com.qihoo.livecloud.tools.SoErrorReport;
import com.qihoo.livecloud.tools.Stats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class GPWebrtcSettings {
    private static GPWebrtcSettings instance;
    private String model;
    private String modelBeforeEncode = Build.BRAND + "_" + Build.MODEL;
    private int enableAec = 1;
    private int aecLevel = 2;
    private int enableCapAgc = 1;
    private int capAgcLevelDb = 3;
    private int capAgcGainDb = 25;
    private int enableCapAgcLimiter = 0;
    private int enableRenderAgc = 0;
    private int renderAgcLevelDb = 3;
    private int renderAgcGainDb = 25;
    private int enableRenderAgcLimiter = 0;
    private int enableNs = 1;
    private int nsLevel = 3;
    private int enableHighPass = 1;
    private int enableVad = 1;
    private int enableHwEncodeH264 = 1;
    private int enableHwDecodeH264 = 1;
    private int enableHwEncodeH265 = 1;
    private int enableHwDecodeH265 = 1;
    private int enableLiveHwEncodeH264 = 1;
    private int enableLiveHwDecodeH264 = 1;
    private int enableLiveHwEncodeH265 = 1;
    private int enableLiveHwDecodeH265 = 1;
    private int enableBeauty = 1;
    private int enableFaceU = 1;
    private int fpsLimiterType = 0;

    private GPWebrtcSettings() {
        this.model = Uri.encode((String)this.modelBeforeEncode);
    }

    public static GPWebrtcSettings getInstance() {
        return instance;
    }

    public void loadConfig() {
        String url = "http://sdk.live.360.cn/rtc";
        HashMap<String, String> kvMap = new HashMap<String, String>();
        kvMap.put("model", this.model);
        kvMap.putAll(Stats.getCommonUrlParam());
        LiveCloudHttpParam httpParam = new LiveCloudHttpParam();
        httpParam.setParameter(kvMap);
        new LCHttpGetByte(url, httpParam, new HttpByteCallBack(){

            @Override
            public void onSuccess(byte[] result) {
                try {
                    String str = "";
                    try {
                        str = GPDecipher.Deciphering(result, result.length);
                    }
                    catch (Throwable e) {
                        SoErrorReport.report("deciphering", -1, false, false);
                    }
                    JSONObject json = new JSONObject(str);
                    GPWebrtcSettings.this.matchConfig(json);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void onFailed(int errCode, byte[] errMessage) {
            }
        }).getByte();
    }

    private void matchConfig(JSONObject json) throws JSONException {
        String aecMode = json.getString("aecMode");
        String rtcAecLevel = json.getString("rtcAecLevel");
        String capAgcMode = json.getString("capAgcMode");
        String rtcCapAgcLevel = json.getString("rtcCapAgcLevel");
        String rtcCapAgcGain = json.getString("rtcCapAgcGain");
        String rtcCapAgcLimiter = json.getString("rtcCapAgcLimiter");
        String renderAgcMode = json.getString("renderAgcMode");
        String rtcRenderAgcLevel = json.getString("rtcRenderAgcLevel");
        String rtcRenderAgcGain = json.getString("rtcRenderAgcGain");
        String rtcRenderAgcLimiter = json.getString("rtcRenderAgcLimiter");
        String nsMode = json.getString("nsMode");
        String rtcNsLevel = json.getString("rtcNsLevel");
        String highpass = json.getString("highpass");
        String vadMode = json.getString("vadMode");
        String hwenc_h264 = json.getString("hwenc_h264");
        String hwdec_h264 = json.getString("hwdec_h264");
        String hwenc_h265 = json.getString("hwenc_h265");
        String hwdec_h265 = json.getString("hwdec_h265");
        String liveHwEncH264 = json.getString("liveHwEncH264");
        String liveHwDecH264 = json.getString("liveHwDecH264");
        String liveHwEncH265 = json.getString("liveHwEncH265");
        String liveHwDecH265 = json.getString("liveHwDecH265");
        String beauty = json.getString("beauty");
        String faceU = json.getString("faceU");
        String capFpsLimiterType = json.getString("capFpsLimiterType");
        if (!TextUtils.isEmpty((CharSequence)aecMode)) {
            this.enableAec = Integer.parseInt(aecMode);
        }
        if (!TextUtils.isEmpty((CharSequence)rtcAecLevel)) {
            this.aecLevel = Integer.parseInt(rtcAecLevel);
        }
        if (!TextUtils.isEmpty((CharSequence)capAgcMode)) {
            this.enableCapAgc = Integer.parseInt(capAgcMode);
        }
        if (!TextUtils.isEmpty((CharSequence)rtcCapAgcLevel)) {
            this.capAgcLevelDb = Integer.parseInt(rtcCapAgcLevel);
        }
        if (!TextUtils.isEmpty((CharSequence)rtcCapAgcGain)) {
            this.capAgcGainDb = Integer.parseInt(rtcCapAgcGain);
        }
        if (!TextUtils.isEmpty((CharSequence)rtcCapAgcLimiter)) {
            this.enableCapAgcLimiter = Integer.parseInt(rtcCapAgcLimiter);
        }
        if (!TextUtils.isEmpty((CharSequence)renderAgcMode)) {
            this.enableRenderAgc = Integer.parseInt(renderAgcMode);
        }
        if (!TextUtils.isEmpty((CharSequence)rtcRenderAgcLevel)) {
            this.renderAgcLevelDb = Integer.parseInt(rtcRenderAgcLevel);
        }
        if (!TextUtils.isEmpty((CharSequence)rtcRenderAgcGain)) {
            this.renderAgcGainDb = Integer.parseInt(rtcRenderAgcGain);
        }
        if (!TextUtils.isEmpty((CharSequence)rtcRenderAgcLimiter)) {
            this.enableRenderAgcLimiter = Integer.parseInt(rtcRenderAgcLimiter);
        }
        if (!TextUtils.isEmpty((CharSequence)nsMode)) {
            this.enableNs = Integer.parseInt(nsMode);
        }
        if (!TextUtils.isEmpty((CharSequence)rtcNsLevel)) {
            this.nsLevel = Integer.parseInt(rtcNsLevel);
        }
        if (!TextUtils.isEmpty((CharSequence)highpass)) {
            this.enableHighPass = Integer.parseInt(highpass);
        }
        if (!TextUtils.isEmpty((CharSequence)vadMode)) {
            this.enableVad = Integer.parseInt(vadMode);
        }
        if (!TextUtils.isEmpty((CharSequence)hwenc_h264)) {
            this.enableHwEncodeH264 = Integer.parseInt(hwenc_h264);
        }
        if (!TextUtils.isEmpty((CharSequence)hwdec_h264)) {
            this.enableHwDecodeH264 = Integer.parseInt(hwdec_h264);
        }
        if (!TextUtils.isEmpty((CharSequence)hwenc_h265)) {
            this.enableHwEncodeH265 = Integer.parseInt(hwenc_h265);
        }
        if (!TextUtils.isEmpty((CharSequence)hwdec_h265)) {
            this.enableHwDecodeH265 = Integer.parseInt(hwdec_h265);
        }
        if (!TextUtils.isEmpty((CharSequence)liveHwEncH264)) {
            this.enableLiveHwEncodeH264 = Integer.parseInt(liveHwEncH264);
        }
        if (!TextUtils.isEmpty((CharSequence)liveHwDecH264)) {
            this.enableLiveHwDecodeH264 = Integer.parseInt(liveHwDecH264);
        }
        if (!TextUtils.isEmpty((CharSequence)liveHwEncH265)) {
            this.enableLiveHwEncodeH265 = Integer.parseInt(liveHwEncH265);
        }
        if (!TextUtils.isEmpty((CharSequence)liveHwDecH265)) {
            this.enableLiveHwDecodeH265 = Integer.parseInt(liveHwDecH265);
        }
        if (!TextUtils.isEmpty((CharSequence)beauty)) {
            this.enableBeauty = Integer.parseInt(beauty);
        }
        if (!TextUtils.isEmpty((CharSequence)faceU)) {
            this.enableFaceU = Integer.parseInt(faceU);
        }
        if (!TextUtils.isEmpty((CharSequence)capFpsLimiterType)) {
            this.fpsLimiterType = Integer.parseInt(capFpsLimiterType);
        }
    }

    public void sendConfig(final UploadListener listener) {
        String url = "http://sdk.live.360.cn/model.php";
        HashMap<String, String> kvMap = new HashMap<String, String>();
        kvMap.put("action", "add");
        kvMap.put("model", this.modelBeforeEncode);
        kvMap.put("aecMode", "" + this.enableAec);
        kvMap.put("rtcAecLevel", "" + this.aecLevel);
        kvMap.put("capAgcMode", "" + this.enableCapAgc);
        kvMap.put("rtcCapAgcLevel", "" + this.capAgcLevelDb);
        kvMap.put("rtcCapAgcGain", "" + this.capAgcGainDb);
        kvMap.put("rtcCapAgcLimiter", "" + this.enableCapAgcLimiter);
        kvMap.put("renderAgcMode", "" + this.enableRenderAgc);
        kvMap.put("rtcRenderAgcLevel", "" + this.renderAgcLevelDb);
        kvMap.put("rtcRenderAgcGain", "" + this.renderAgcGainDb);
        kvMap.put("rtcRenderAgcLimiter", "" + this.enableRenderAgcLimiter);
        kvMap.put("nsMode", "" + this.enableNs);
        kvMap.put("rtcNsLevel", "" + this.nsLevel);
        kvMap.put("highpass", "" + this.enableHighPass);
        kvMap.put("vadMode", "" + this.enableVad);
        kvMap.put("hwenc_h264", "" + this.enableHwEncodeH264);
        kvMap.put("hwdec_h264", "" + this.enableHwDecodeH264);
        kvMap.put("hwenc_h265", "" + this.enableHwEncodeH265);
        kvMap.put("hwdec_h265", "" + this.enableHwDecodeH265);
        kvMap.put("liveHwEncH264", "" + this.enableLiveHwEncodeH264);
        kvMap.put("liveHwDecH264", "" + this.enableLiveHwDecodeH264);
        kvMap.put("liveHwEncH265", "" + this.enableLiveHwEncodeH265);
        kvMap.put("liveHwDecH265", "" + this.enableLiveHwDecodeH265);
        kvMap.put("beauty", "" + this.enableBeauty);
        kvMap.put("faceU", "" + this.enableFaceU);
        kvMap.put("capFpsLimiterType", "" + this.fpsLimiterType);
        kvMap.put("tm", "" + System.currentTimeMillis() / 1000L);
        Set keyset = kvMap.keySet();
        ArrayList<String> list = new ArrayList<String>(keyset);
        Collections.sort(list);
        kvMap.put("secretkey", "a62de771894c03f5f9a471effd2f5d89");
        list.add("secretkey");
        String kv = this.getKvList(list, kvMap);
        kvMap.put("_sign", MD5.encryptMD5(kv));
        kvMap.remove("secretkey");
        kvMap.put("model", this.model);
        LiveCloudHttpParam httpParam = new LiveCloudHttpParam();
        httpParam.setParameter(kvMap);
        new LCHttpGet(url, httpParam, new HttpCallBack(){

            @Override
            public void onSuccess(String result) {
                GPThreadTools.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onOver();
                    }
                });
            }

            @Override
            public void onFailed(int errCode, String errMessage) {
                GPThreadTools.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onError();
                    }
                });
            }

            @Override
            public void onProgressAdd(int add) {
            }
        }).get();
    }

    private String getKvList(List<String> keys, HashMap<String, String> original) {
        if (original == null || original.size() <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String key : keys) {
            String value = original.get(key);
            sb.append(key);
            sb.append(value);
        }
        return sb.toString();
    }

    public int getEnableAec() {
        return this.enableAec;
    }

    public void setEnableAec(int enableAec) {
        this.enableAec = enableAec;
    }

    public int getAecLevel() {
        return this.aecLevel;
    }

    public void setAecLevel(int aecLevel) {
        this.aecLevel = aecLevel;
    }

    public int getEnableCapAgc() {
        return this.enableCapAgc;
    }

    public void setEnableCapAgc(int enableCapAgc) {
        this.enableCapAgc = enableCapAgc;
    }

    public int getCapAgcLevelDb() {
        return this.capAgcLevelDb;
    }

    public void setCapAgcLevelDb(int capAgcLevelDb) {
        this.capAgcLevelDb = capAgcLevelDb;
    }

    public int getCapAgcGainDb() {
        return this.capAgcGainDb;
    }

    public void setCapAgcGainDb(int capAgcGainDb) {
        this.capAgcGainDb = capAgcGainDb;
    }

    public int getEnableCapAgcLimiter() {
        return this.enableCapAgcLimiter;
    }

    public void setEnableCapAgcLimiter(int enableCapAgcLimiter) {
        this.enableCapAgcLimiter = enableCapAgcLimiter;
    }

    public int getEnableRenderAgc() {
        return this.enableRenderAgc;
    }

    public int getRenderAgcLevelDb() {
        return this.renderAgcLevelDb;
    }

    public void setRenderAgcLevelDb(int renderAgcLevelDb) {
        this.renderAgcLevelDb = renderAgcLevelDb;
    }

    public int getRenderAgcGainDb() {
        return this.renderAgcGainDb;
    }

    public void setRenderAgcGainDb(int renderAgcGainDb) {
        this.renderAgcGainDb = renderAgcGainDb;
    }

    public int getEnableRenderAgcLimiter() {
        return this.enableRenderAgcLimiter;
    }

    public void setEnableRenderAgcLimiter(int enableRenderAgcLimiter) {
        this.enableRenderAgcLimiter = enableRenderAgcLimiter;
    }

    public void setEnableRenderAgc(int enableRenderAgc) {
        this.enableRenderAgc = enableRenderAgc;
    }

    public int getEnableNs() {
        return this.enableNs;
    }

    public void setEnableNs(int enableNs) {
        this.enableNs = enableNs;
    }

    public int getNsLevel() {
        return this.nsLevel;
    }

    public void setNsLevel(int nsLevel) {
        this.nsLevel = nsLevel;
    }

    public int getEnableHighPass() {
        return this.enableHighPass;
    }

    public void setEnableHighPass(int enableHighPass) {
        this.enableHighPass = enableHighPass;
    }

    public int getEnableVad() {
        return this.enableVad;
    }

    public void setEnableVad(int enableVad) {
        this.enableVad = enableVad;
    }

    public int getEnableHwEncodeH264() {
        return this.enableHwEncodeH264;
    }

    public void setEnableHwEncodeH264(int enableHwEncodeH264) {
        this.enableHwEncodeH264 = enableHwEncodeH264;
    }

    public int getEnableHwDecodeH264() {
        return this.enableHwDecodeH264;
    }

    public void setEnableHwDecodeH264(int enableHwDecodeH264) {
        this.enableHwDecodeH264 = enableHwDecodeH264;
    }

    public int getEnableHwEncodeH265() {
        return this.enableHwEncodeH265;
    }

    public void setEnableHwEncodeH265(int enableHwEncodeH265) {
        this.enableHwEncodeH265 = enableHwEncodeH265;
    }

    public int getEnableHwDecodeH265() {
        return this.enableHwDecodeH265;
    }

    public void setEnableHwDecodeH265(int enableHwDecodeH265) {
        this.enableHwDecodeH265 = enableHwDecodeH265;
    }

    public int getEnableLiveHwEncodeH264() {
        return this.enableLiveHwEncodeH264;
    }

    public void setEnableLiveHwEncodeH264(int enableLiveHwEncodeH264) {
        this.enableLiveHwEncodeH264 = enableLiveHwEncodeH264;
    }

    public int getEnableLiveHwDecodeH264() {
        return this.enableLiveHwDecodeH264;
    }

    public void setEnableLiveHwDecodeH264(int enableLiveHwDecodeH264) {
        this.enableLiveHwDecodeH264 = enableLiveHwDecodeH264;
    }

    public int getEnableLiveHwEncodeH265() {
        return this.enableLiveHwEncodeH265;
    }

    public void setEnableLiveHwEncodeH265(int enableLiveHwEncodeH265) {
        this.enableLiveHwEncodeH265 = enableLiveHwEncodeH265;
    }

    public int getEnableLiveHwDecodeH265() {
        return this.enableLiveHwDecodeH265;
    }

    public void setEnableLiveHwDecodeH265(int enableLiveHwDecodeH265) {
        this.enableLiveHwDecodeH265 = enableLiveHwDecodeH265;
    }

    public int getEnableBeauty() {
        return this.enableBeauty;
    }

    public void setEnableBeauty(int enableBeauty) {
        this.enableBeauty = enableBeauty;
    }

    public int getEnableFaceU() {
        return this.enableFaceU;
    }

    public void setEnableFaceU(int enableFaceU) {
        this.enableFaceU = enableFaceU;
    }

    public int getFpsLimiterType() {
        return this.fpsLimiterType;
    }

    public void setFpsLimiterType(int fpsLimiterType) {
        this.fpsLimiterType = fpsLimiterType;
    }

    static {
        LocalSoLoadManager.getInstance().loadSo("transcore");
        instance = new GPWebrtcSettings();
    }

    public static interface UploadListener {
        public void onOver();

        public void onError();
    }
}

