/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.qihoo.livecloud.network.HttpCallBack;
import com.qihoo.livecloud.network.LCHttpGet;
import com.qihoo.livecloud.network.LiveCloudHttpParam;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.Stats;
import com.qihoo.livecloud.utils.PreferencesUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class CloudControlManager {
    static final String TAG = "NewCloudControl";
    private Context sContext;
    private volatile SharedPreferences sDatabase;
    private static final String SP_NAME = "sp.livecloud.database";
    private static final int SP_MODE = 0;
    private static final String KEY_CONFIG = "key.config";
    private static final int CONFIG_UPATE_INTERVAL_TIME = 300000;
    private String mConfigJson;
    private String mBid;
    private String mVersion;
    private String mUrl = "http://sdk.live.360.cn";
    private Set<updateConfigCallback> mCallbacks = new HashSet<updateConfigCallback>();
    private Timer mTimer = null;
    private TimerTask mTimerTask = null;
    private Handler mHandler;
    private Object mLockObject = new Object();
    private PreferencesUtils preferencesUtils;
    private AtomicBoolean mUpdatingConfig = new AtomicBoolean(false);
    private static CloudControlManager instance;

    public static synchronized CloudControlManager getInstance() {
        if (instance == null) {
            instance = new CloudControlManager();
        }
        return instance;
    }

    public void loadConfig(Context context, String configUrl, String bid, String ver, updateConfigCallback callback) {
        this.sContext = context;
        this.mBid = bid;
        this.mVersion = ver;
        this.addCallback(callback);
        if (this.preferencesUtils == null) {
            this.preferencesUtils = new PreferencesUtils(this.sContext, SP_NAME);
        }
        if (configUrl != null && configUrl.startsWith("http")) {
            this.mUrl = configUrl;
        }
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        this.updateConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(updateConfigCallback callback) {
        CloudControlManager cloudControlManager = this;
        synchronized (cloudControlManager) {
            if (callback != null) {
                this.mCallbacks.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(updateConfigCallback callback) {
        CloudControlManager cloudControlManager = this;
        synchronized (cloudControlManager) {
            if (callback != null) {
                this.mCallbacks.remove(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<updateConfigCallback> getAllCallback() {
        HashSet<updateConfigCallback> callbacks = new HashSet<updateConfigCallback>();
        CloudControlManager cloudControlManager = this;
        synchronized (cloudControlManager) {
            callbacks.addAll(this.mCallbacks);
        }
        return callbacks;
    }

    public void updateConfig() {
        if (TextUtils.isEmpty((CharSequence)this.mBid)) {
            return;
        }
        if (this.mUpdatingConfig.get()) {
            return;
        }
        this.mUpdatingConfig.set(true);
        String url = this.mUrl;
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + this.mBid + "_android_" + this.mVersion + ".conf";
        HashMap<String, String> kvMap = new HashMap<String, String>();
        kvMap.putAll(Stats.getCommonUrlParam());
        LiveCloudHttpParam httpParam = new LiveCloudHttpParam();
        httpParam.setParameter(kvMap);
        new LCHttpGet(url, httpParam, new HttpCallBack(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(String result) {
                CloudControlManager.this.mUpdatingConfig.set(false);
                Logger.v(CloudControlManager.TAG, "raw " + result);
                Object object = CloudControlManager.this.mLockObject;
                synchronized (object) {
                    if (!TextUtils.isEmpty((CharSequence)result)) {
                        CloudControlManager.this.setString(CloudControlManager.KEY_CONFIG, result);
                        CloudControlManager.this.mConfigJson = CloudControlManager.decryptAES(result);
                    }
                }
                CloudControlManager.this.setupUpdateTimer();
                Set callbacks = CloudControlManager.this.getAllCallback();
                if (callbacks != null) {
                    for (updateConfigCallback callback : callbacks) {
                        if (callback == null) continue;
                        callback.updateConfigFinish();
                    }
                }
            }

            @Override
            public void onFailed(int errCode, String errMessage) {
                CloudControlManager.this.mUpdatingConfig.set(false);
                CloudControlManager.this.setupUpdateTimer();
                Set callbacks = CloudControlManager.this.getAllCallback();
                if (callbacks != null) {
                    for (updateConfigCallback callback : callbacks) {
                        if (callback == null) continue;
                        callback.updateConfigFinish();
                    }
                }
            }

            @Override
            public void onProgressAdd(int add) {
            }
        }).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConfigJson() {
        Object object = this.mLockObject;
        synchronized (object) {
            if (TextUtils.isEmpty((CharSequence)this.mConfigJson)) {
                this.mConfigJson = CloudControlManager.decryptAES(this.getString(KEY_CONFIG));
            }
            return this.mConfigJson;
        }
    }

    public void initUpdateTimer() {
        long update_interval = 0L;
        String configJson = this.getConfigJson();
        if (!TextUtils.isEmpty((CharSequence)configJson)) {
            try {
                JSONObject jsonComm;
                JSONObject json = new JSONObject(configJson);
                if (json != null && (jsonComm = json.optJSONObject("common")) != null && jsonComm.has("update_interval")) {
                    update_interval = jsonComm.getLong("update_interval") * 1000L;
                    Logger.v(TAG, "comm json get update_interval " + update_interval);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (update_interval == 0L) {
            update_interval = 300000L;
        }
        if (this.mTimer == null) {
            this.mTimer = new Timer();
        }
        if (this.mTimerTask == null) {
            this.mTimerTask = new TimerTask(){

                @Override
                public void run() {
                    CloudControlManager.this.updateConfig();
                }
            };
        }
        try {
            this.mTimer.scheduleAtFixedRate(this.mTimerTask, update_interval, update_interval);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unInitUpdateTimer() {
        if (this.mTimerTask != null) {
            this.mTimerTask.cancel();
            this.mTimerTask = null;
        }
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    public void setConfigUrl(String configUrl) {
        if (configUrl != null && configUrl.startsWith("http")) {
            this.mUrl = configUrl;
        }
    }

    protected void finalize() throws Throwable {
        this.unInitUpdateTimer();
        super.finalize();
    }

    private void setString(String key, String value) {
        if (this.preferencesUtils != null) {
            this.preferencesUtils.putString(key, value);
        }
    }

    private String getString(String key) {
        if (this.preferencesUtils != null) {
            return this.preferencesUtils.getString(key);
        }
        return "";
    }

    private static String decryptAES(String value) {
        if (value == null) {
            return "";
        }
        try {
            String ret = Stats.decryptConfig(value.getBytes("UTF-8"));
            Logger.v(TAG, "json " + ret);
            return ret;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            Logger.e(TAG, "json " + ex.getMessage());
            return "";
        }
    }

    private void setupUpdateTimer() {
        if (this.mHandler != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    CloudControlManager.this.unInitUpdateTimer();
                    CloudControlManager.this.initUpdateTimer();
                }
            });
        }
    }

    public static interface updateConfigCallback {
        public void updateConfigFinish();
    }
}

