/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.text.TextUtils;
import com.qihoo.livecloud.tools.Logger;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class CloudControlTrans {
    static final String TAG = "NewCloudControl";
    public int dns_cache_enable = 1;
    public int dns_cache_seconds = 300000;
    public int time_adjust_threshold = 200;
    public int no_stats_upload = 0;
    public int upload_dump = 0;
    public int write_file_log = 0;
    public int enable = 1;

    public static CloudControlTrans fromJsonString(String jsonStr) {
        CloudControlTrans cloudControl = new CloudControlTrans();
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return cloudControl;
        }
        try {
            JSONObject json = new JSONObject(jsonStr);
            JSONObject jsonCloudControl = json.optJSONObject("common");
            if (jsonCloudControl != null) {
                if (jsonCloudControl.has("enable") && jsonCloudControl.getInt("enable") == 0) {
                    Logger.i(TAG, "CloudControlTrans enable = 0 return " + cloudControl.toString());
                    return cloudControl;
                }
                Iterator keys = jsonCloudControl.keys();
                int count = 0;
                int matchCount = 0;
                int notMatchCount = 0;
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    ++count;
                    if (key.equals("use_dns_cache")) {
                        cloudControl.dns_cache_enable = jsonCloudControl.getInt(key);
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("dns_cache_timeout")) {
                        cloudControl.dns_cache_seconds = jsonCloudControl.getInt(key);
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("time_adjust_threshold")) {
                        cloudControl.time_adjust_threshold = jsonCloudControl.getInt(key);
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("no_stats_upload")) {
                        cloudControl.no_stats_upload = jsonCloudControl.getInt(key);
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("upload_dump")) {
                        cloudControl.upload_dump = jsonCloudControl.getInt(key);
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("write_file_log")) {
                        cloudControl.write_file_log = jsonCloudControl.getInt(key);
                        ++matchCount;
                        continue;
                    }
                    if (key.equals("enable")) {
                        cloudControl.enable = jsonCloudControl.getInt(key);
                        ++matchCount;
                        continue;
                    }
                    Logger.v(TAG, "not match key =  " + key);
                    ++notMatchCount;
                }
                Logger.v(TAG, "comm json all obj count " + count + " var count " + cloudControl.getVarCount() + " match count " + matchCount + " not match count " + notMatchCount);
                Logger.v(TAG, cloudControl.toString());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return cloudControl;
    }

    public String toString() {
        return "CloudControlTrans{dns_cache_enable=" + this.dns_cache_enable + ", dns_cache_seconds=" + this.dns_cache_seconds + ", time_adjust_threshold=" + this.time_adjust_threshold + ", no_stats_upload=" + this.no_stats_upload + ", upload_dump=" + this.upload_dump + ", write_file_log=" + this.write_file_log + ", enable=" + this.enable + '}';
    }

    public int getVarCount() {
        int count = 0;
        try {
            String strValue = this.toString();
            Pattern pattern = Pattern.compile("=");
            Matcher matcher = pattern.matcher(strValue);
            while (matcher.find()) {
                ++count;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return count;
    }
}

