/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.os.Build;
import android.text.TextUtils;
import com.qihoo.livecloud.network.HttpCallBack;
import com.qihoo.livecloud.network.LCHttpGet;
import com.qihoo.livecloud.network.LiveCloudHttpParam;
import com.qihoo.livecloud.tools.LogEntry;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.Stats;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class CodecConfig {
    private int canHWEncode = 1;
    private int canHWDecode = 0;
    private int canRtcHWEncode = 1;
    private int mEnableFaceu = 1;
    private int mEnableBeauty = 1;
    private int mEnableAEC = 1;
    private String bid;
    private String ver;
    private String sdkVer;
    private String mid;
    private String pid = "ANDROID";
    private String model = Build.BRAND + "_" + Build.MODEL;
    private String mUrlCc;
    public static final String TAG = "LiveCloud";

    private CodecConfig() {
    }

    public static CodecConfig getInstance() {
        return CodecConfigHolder.instance;
    }

    public void getCodecConfigFromServer() {
        if (TextUtils.isEmpty((CharSequence)this.mUrlCc)) {
            this.mUrlCc = "http://sdk.live.360.cn/";
        }
        if (!this.mUrlCc.endsWith("/")) {
            this.mUrlCc = this.mUrlCc + "/";
        }
        String url = this.mUrlCc + "codec";
        LiveCloudHttpParam httpParam = new LiveCloudHttpParam();
        httpParam.setParameter(this.createParameters());
        HttpCallBack callBack = new HttpCallBack(){

            @Override
            public void onSuccess(String result) {
                Logger.iif(LogEntry.logGetTransportId(), CodecConfig.TAG, "LiveCloud, getCodecConfigFromServer result: " + result);
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    try {
                        int ret;
                        JSONObject json = new JSONObject(result);
                        if (json != null && (ret = CodecConfig.this.getJsonInt(json, "ret", -1)) == 0) {
                            int encode = CodecConfig.this.getJsonInt(json, "live_encode", 1);
                            int decode = CodecConfig.this.getJsonInt(json, "live_decode", 1);
                            int rtcEncode = CodecConfig.this.getJsonInt(json, "rtc_encode", 1);
                            int enableFaceu = CodecConfig.this.getJsonInt(json, "faceu_enable", 1);
                            int enableBeauty = CodecConfig.this.getJsonInt(json, "beauty_enable", 1);
                            int enableAEC = CodecConfig.this.getJsonInt(json, "aec_enable", 1);
                            CodecConfig.this.canHWEncode = encode;
                            CodecConfig.this.canHWDecode = decode;
                            CodecConfig.this.canRtcHWEncode = rtcEncode;
                            CodecConfig.this.mEnableBeauty = enableBeauty;
                            CodecConfig.this.mEnableFaceu = enableFaceu;
                            CodecConfig.this.mEnableAEC = enableAEC;
                        }
                    }
                    catch (JSONException e) {
                        Logger.e(CodecConfig.TAG, "LiveCloud," + e.getMessage());
                    }
                }
            }

            @Override
            public void onFailed(int errCode, String errMessage) {
                Logger.ef(LogEntry.logGetTransportId(), CodecConfig.TAG, "LiveCloud, getCodecConfigFromServer failed, errCode: " + errCode + ", errMessage: " + errMessage);
            }

            @Override
            public void onProgressAdd(int add) {
            }
        };
        LCHttpGet httpGet = new LCHttpGet(url, httpParam, callBack);
        httpGet.get();
    }

    private int getJsonInt(JSONObject json, String key, int defaultValue) {
        if (json != null && !TextUtils.isEmpty((CharSequence)key) && json.has(key)) {
            try {
                int value = json.getInt(key);
                return value;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return defaultValue;
    }

    private HashMap<String, ?> createParameters() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("bid", this.bid);
        param.put("ver", this.ver);
        param.put("sdk_ver", this.sdkVer);
        param.put("mid", this.mid);
        param.put("pid", this.pid);
        param.put("model", this.urlEncode(this.model));
        param.putAll(Stats.getCommonUrlParam());
        return param;
    }

    private String urlEncode(String param) {
        String pm = param;
        try {
            pm = URLEncoder.encode(param.toString(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return pm;
    }

    protected void setBid(String bid) {
        this.bid = bid;
    }

    protected void setVer(String ver) {
        this.ver = ver;
    }

    protected void setMid(String mid) {
        this.mid = mid;
    }

    protected void setUrlCc(String url) {
        this.mUrlCc = url;
    }

    public boolean supportHardwareEncode() {
        return this.canHWEncode == 1;
    }

    public boolean supportHardwareDecode() {
        return this.canHWDecode == 1;
    }

    public boolean supportRtcHardwareEncode() {
        return this.canRtcHWEncode == 1;
    }

    public boolean enableBeauty() {
        return this.mEnableBeauty == 1;
    }

    public boolean enableFaceu() {
        return this.mEnableFaceu == 1;
    }

    public boolean enableAEC() {
        return this.mEnableAEC == 1;
    }

    private static class CodecConfigHolder {
        private static CodecConfig instance = new CodecConfig();

        private CodecConfigHolder() {
        }
    }
}

