/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.MD5;
import java.lang.reflect.Method;

public class DeviceIDUtils {
    private static final String TAG = "DeviceIDUtils";
    private static String sImei2 = "";
    private static String sImei = "";
    private static final String DEFAULT_IMEI = "360LIVECLOUD_DEFAULT_IMEI";

    public static String getIMEI2(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sImei2)) {
            Logger.d(TAG, "m2 = " + sImei2);
            return sImei2;
        }
        String imei = DeviceIDUtils.getIMEI(context);
        String androidId = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        String serialNo = DeviceIDUtils.getDeviceSerial();
        sImei2 = MD5.encryptMD5("" + imei + androidId + serialNo);
        return sImei2;
    }

    private static String getIMEI(Context c) {
        try {
            if (!TextUtils.isEmpty((CharSequence)sImei)) {
                return sImei;
            }
            sImei = ((TelephonyManager)c.getApplicationContext().getSystemService("phone")).getDeviceId();
            if (!TextUtils.isEmpty((CharSequence)sImei)) {
                return sImei;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return DEFAULT_IMEI;
    }

    public static String getIMSI(Context c) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)c.getApplicationContext().getSystemService("phone");
            String sRet = telephonyManager.getSubscriberId();
            return sRet;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static String getDeviceSerial() {
        String serial = "";
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class);
            serial = (String)get.invoke(c, "ro.serialno");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serial;
    }
}

