/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.qihoo.livecloud.plugin.core.PluginAbiHelper;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.RunnableManager;
import com.qihoo.livecloud.tools.SDKUtils;
import com.qihoo.livecloud.tools.SoErrorReport;
import com.qihoo.livecloud.tools.SoLoadTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LocalSoLoadManager {
    static final String TAG = "LocalSoLoadManager";
    @SuppressLint(value={"StaticFieldLeak"})
    private static LocalSoLoadManager instance;
    private static int MAX_TRIES;
    private static int CHECK_SO_IN_APK;
    private Context mContext;
    private Handler mHanlder;
    private Runnable mLoadSoRunnable;
    private AtomicInteger mCheckStatus = new AtomicInteger(-1);
    private HashSet<String> mSoSetInApk = new HashSet();
    private HashSet<String> mSoSetDynamic = new HashSet();
    private ArrayList<String> mSoToLoad = new ArrayList();
    private final Object mLock = new Object();
    static boolean apkCheckFinish;

    public static synchronized boolean isApkCheckFinish() {
        return apkCheckFinish;
    }

    public static synchronized void setApkCheckFinish(boolean checkFinish) {
        apkCheckFinish = checkFinish;
    }

    public static synchronized LocalSoLoadManager getInstance() {
        if (instance == null) {
            instance = new LocalSoLoadManager();
        }
        return instance;
    }

    public void init(Context context) {
        if (context != null) {
            this.mContext = context.getApplicationContext();
            this.mHanlder = new Handler(Looper.getMainLooper());
        }
        this.mLoadSoRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList soToLoad = new ArrayList();
                Object object = LocalSoLoadManager.this.mLock;
                synchronized (object) {
                    soToLoad.addAll(LocalSoLoadManager.this.mSoToLoad);
                    LocalSoLoadManager.this.mSoToLoad.clear();
                }
                for (int i = 0; i < soToLoad.size(); ++i) {
                    String soName = (String)soToLoad.get(i);
                    if (LocalSoLoadManager.this.isSoInApk(soName) && !LocalSoLoadManager.this.isSoDynamicLoad(soName)) {
                        LocalSoLoadManager.this.wrietLog("mLoadSoRunnable load so " + soName);
                        boolean ret = SDKUtils.loadLibrary(LocalSoLoadManager.this.mContext, soName);
                        if (!ret || soName.compareToIgnoreCase("transcore") != 0) continue;
                        RunnableManager.getInstance().runAll();
                        continue;
                    }
                    LocalSoLoadManager.this.wrietLog("mLoadSoRunnable not need load so " + soName);
                }
                SoLoadTool.verifyLibrary(LocalSoLoadManager.this.mContext);
            }
        };
        if (Build.VERSION.SDK_INT < CHECK_SO_IN_APK) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    long time = System.currentTimeMillis();
                    LocalSoLoadManager.this.checkSoInApk();
                    LocalSoLoadManager.this.wrietLog("checkSoInApk use time: " + (System.currentTimeMillis() - time));
                }
            }).start();
        } else {
            LocalSoLoadManager.setApkCheckFinish(true);
            SoLoadTool.verifyLibrary(this.mContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSoInApk(String soName) {
        if (this.mCheckStatus.get() == 0) {
            return true;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSoSetInApk.contains(soName)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSoDynamicLoad(String soName) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSoSetDynamic.contains(soName)) {
                return true;
            }
        }
        return false;
    }

    void loadSoSync(String ... soNames) {
        if (Build.VERSION.SDK_INT < CHECK_SO_IN_APK) {
            for (String soName : soNames) {
                if (this.isSoInApk(soName) && !this.isSoDynamicLoad(soName)) {
                    SDKUtils.loadLibrary(this.mContext, soName);
                    this.wrietLog("loadSoSync check:" + soName);
                    continue;
                }
                this.wrietLog("loadSoSync not need load so " + soName);
            }
        } else {
            for (String soName : soNames) {
                SDKUtils.loadLibrary(this.mContext, soName);
                this.wrietLog("loadSoSync no check:" + soName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSo(String ... soNames) {
        block10: {
            block8: {
                block9: {
                    if (Build.VERSION.SDK_INT >= CHECK_SO_IN_APK) break block8;
                    if (this.mCheckStatus.get() != -1) break block9;
                    if (this.mHanlder == null || this.mLoadSoRunnable == null) break block10;
                    for (String soName : soNames) {
                        Object object = this.mLock;
                        synchronized (object) {
                            if (!this.isSoDynamicLoad(soName)) {
                                this.mSoToLoad.add(soName);
                            }
                            this.wrietLog("loadSo save to list: " + soName);
                        }
                    }
                    break block10;
                }
                for (String soName : soNames) {
                    if (this.isSoInApk(soName) && !this.isSoDynamicLoad(soName)) {
                        SDKUtils.loadLibrary(this.mContext, soName);
                        this.wrietLog("loadSo check finish:" + soName);
                        continue;
                    }
                    this.wrietLog("loadSo not need load so " + soName + " isSoInApk " + this.isSoInApk(soName) + " isSoDynamicLoad " + this.isSoDynamicLoad(soName));
                }
                break block10;
            }
            for (String soName : soNames) {
                SDKUtils.loadLibrary(this.mContext, soName);
                this.wrietLog("loadSo no check:" + soName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelLoadSo(String ... soNames) {
        if (Build.VERSION.SDK_INT < CHECK_SO_IN_APK) {
            for (String soName : soNames) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mSoToLoad.remove(soName);
                    this.mSoSetDynamic.add(soName);
                }
                this.wrietLog("cancelLoadSo: " + soName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSoInApk() {
        ZipFile zipFile = null;
        try {
            if (this.mContext == null) {
                throw new IllegalArgumentException("checkSoInApk context is null");
            }
            ApplicationInfo appInfo = this.mContext.getApplicationInfo();
            int tries = 0;
            while (tries++ < MAX_TRIES) {
                try {
                    zipFile = new ZipFile(new File(appInfo.sourceDir), 1);
                    break;
                }
                catch (IOException iOException) {
                }
            }
            if (zipFile == null) {
                this.wrietLog("zipFile error ");
                throw new IOException("checkSoInApk read apk failed");
            }
            String jniPathName = "lib" + File.separatorChar + PluginAbiHelper.getCurrentAbi(this.mContext) + File.separatorChar;
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String filePath = entry.getName();
                if (TextUtils.isEmpty((CharSequence)filePath) || !filePath.startsWith(jniPathName)) continue;
                String fileName = filePath.replace(jniPathName + "lib", "");
                if (TextUtils.isEmpty((CharSequence)(fileName = fileName.replace(".so", "")))) continue;
                Object object = this.mLock;
                synchronized (object) {
                    this.mSoSetInApk.add(fileName);
                    this.wrietLog("get so in apk " + fileName);
                }
            }
            this.mCheckStatus.set(1);
        }
        catch (Throwable e) {
            this.mCheckStatus.set(0);
            SoErrorReport.report("checkSoInApk", -1, false, false);
        }
        finally {
            LocalSoLoadManager.setApkCheckFinish(true);
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException appInfo) {}
            this.mHanlder.removeCallbacks(this.mLoadSoRunnable);
            this.mHanlder.post(this.mLoadSoRunnable);
        }
    }

    public static void loadLibrary(String soName) {
        LocalSoLoadManager.getInstance().loadSo(soName);
    }

    private void wrietLog(String log) {
        Logger.d(TAG, log);
    }

    static {
        MAX_TRIES = 3;
        CHECK_SO_IN_APK = 21;
        apkCheckFinish = false;
    }
}

