/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.content.Context;
import android.text.TextUtils;
import com.qihoo.livecloud.tools.DirUtil;
import com.qihoo.livecloud.tools.LocalSoLoadManager;
import com.qihoo.livecloud.tools.LogPrintCallBack;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.SoErrorReport;
import com.qihoo.livecloud.tools.SoLoadTool;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LogEntry {
    private static final String TAG = "LogEntry";
    static LogPrintCallBack mLogPrintCallBack;
    private static String mLogDir;
    private static boolean mUserLogStart;
    private static ConcurrentHashMap<String, Integer> mLoggerIDs;
    private static final int FILE_LOG_LENGTH = 3;
    private static final int FILE_LOG_COUNT = 3;
    private static LogPrintCallBack logPrintCallBack;

    private static void loadLibrary(Context context) {
        LocalSoLoadManager.getInstance().loadSo("transcore");
    }

    private static native void logstart();

    private static native void logsetlogcb(LogPrintCallBack var0);

    private static native void logsetloglevel(int var0, int var1);

    private static native int loggettransportid();

    private static native int loggetplayerid();

    private static native int loggetcameraid();

    public static void logStart(Context context) {
        LogEntry.loadLibrary(context.getApplicationContext());
        if (!LogEntry.isSoLoaded()) {
            return;
        }
        mUserLogStart = true;
        LogEntry.logstart();
        LogEntry.logSetLogCb();
    }

    private static void logSetLogCb() {
        if (!LogEntry.isSoLoaded()) {
            return;
        }
        LogEntry.logsetlogcb(logPrintCallBack);
    }

    public static void logSetLogCb(LogPrintCallBack callback) {
        if (mLogPrintCallBack != null) {
            mLogPrintCallBack = null;
        }
        mLogPrintCallBack = callback;
    }

    public static void logSetLogLevel(int loggerID, int logLevel) {
        Logger.d(TAG, "loggerID : " + loggerID + " logLevel : " + logLevel);
        if (!LogEntry.isSoLoaded()) {
            return;
        }
        if (mUserLogStart) {
            LogEntry.logsetloglevel(loggerID, logLevel);
        }
    }

    public static int logGetTransportId() {
        if (!LogEntry.isSoLoaded()) {
            return -1;
        }
        try {
            return LogEntry.loggettransportid();
        }
        catch (UnsatisfiedLinkError e) {
            return -1;
        }
    }

    public static int logGetPlayerId() {
        if (!LogEntry.isSoLoaded()) {
            return -1;
        }
        try {
            return LogEntry.loggetplayerid();
        }
        catch (UnsatisfiedLinkError e) {
            return -1;
        }
    }

    static void init(Context context, String bid) {
        if (!LogEntry.isSoLoaded()) {
            return;
        }
        if (context != null) {
            mLogDir = DirUtil.getLogDir(context, bid);
            mLoggerIDs.put("trans", LogEntry.logGetTransportId());
            mLoggerIDs.put("player", LogEntry.logGetPlayerId());
            try {
                LogEntry.logstart();
            }
            catch (Throwable e) {
                SoErrorReport.report("logstart", -1, false, false);
            }
            for (Map.Entry<String, Integer> entry : mLoggerIDs.entrySet()) {
                int loggerID = entry.getValue();
                try {
                    if (!mUserLogStart) {
                        LogEntry.logsetloglevel(loggerID, 6);
                    }
                    LogEntry.logsetlogpath(loggerID, mLogDir);
                    LogEntry.logsetloglevelforfile(loggerID, 4);
                    LogFileParams params = new LogFileParams();
                    params.singleSize = 3;
                    params.persistenceNum = 3;
                    LogEntry.logsetlogparams(loggerID, params);
                }
                catch (Throwable e) {
                    SoErrorReport.report("logsetlogpath", -1, false, false);
                }
            }
        } else {
            Logger.d(TAG, "LogEntry init param context is null!");
        }
    }

    public static int createLogger(String logger) {
        int loggerID;
        block7: {
            if (mLoggerIDs.containsKey(logger)) {
                return mLoggerIDs.get(logger);
            }
            if (!LogEntry.isSoLoaded()) {
                return -1;
            }
            if (TextUtils.isEmpty((CharSequence)mLogDir)) {
                return -1;
            }
            loggerID = -1;
            try {
                loggerID = LogEntry.logcreatelogger(logger);
                if (loggerID < 0) break block7;
                mLoggerIDs.put(logger, loggerID);
                LogEntry.logsetlogpath(loggerID, mLogDir);
                LogEntry.logsetloglevelforfile(loggerID, 2);
                try {
                    LogEntry.logsetlogdisplay(loggerID, false);
                }
                catch (Throwable e) {
                    SoErrorReport.report("logsetlogdisplay", -1, false, false);
                }
                LogFileParams params = new LogFileParams();
                params.singleSize = 3;
                params.persistenceNum = 3;
                LogEntry.logsetlogparams(loggerID, params);
            }
            catch (Throwable e) {
                SoErrorReport.report("logsetlogpath", -2, false, false);
            }
        }
        return loggerID;
    }

    static void logFile(int loggerID, int logLevel, String format, Object ... args) {
        if (!LogEntry.isSoLoaded()) {
            return;
        }
        try {
            String message = String.format(format, args);
            LogEntry.log(loggerID, logLevel, message);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static File[] getLogFiles() {
        if (TextUtils.isEmpty((CharSequence)mLogDir)) {
            return null;
        }
        File path = new File(mLogDir);
        if (!path.exists()) {
            return null;
        }
        return path.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                if (TextUtils.isEmpty((CharSequence)filename)) {
                    return false;
                }
                File file = new File(filename);
                if (!file.getName().toLowerCase().contains(".log")) {
                    return false;
                }
                return file.length() <= 6L;
            }
        });
    }

    public static String[] getLogFiles(int loggerID) {
        String path = LogEntry.loggetlogfiles(loggerID);
        if (!TextUtils.isEmpty((CharSequence)path)) {
            return path.split(",");
        }
        return null;
    }

    private static boolean isSoLoaded() {
        return SoLoadTool.isSoLoaded();
    }

    private static native int logcreatelogger(String var0);

    private static native void logsetloglevelforfile(int var0, int var1);

    private static native void logsetlogpath(int var0, String var1);

    private static native String loggetlogfiles(int var0);

    private static native void logsetlogdisplay(int var0, boolean var1);

    private static native void logsetlogparams(int var0, LogFileParams var1);

    private static native void log(int var0, int var1, String var2);

    static {
        mUserLogStart = false;
        mLoggerIDs = new ConcurrentHashMap();
        LogEntry.loadLibrary(null);
        logPrintCallBack = new LogPrintCallBack(){

            @Override
            public void logPrint(int loggerID, int level, String data) {
                if (mLogPrintCallBack != null) {
                    mLogPrintCallBack.logPrint(loggerID, level, data);
                }
            }
        };
    }

    private static class LogFileParams {
        int singleSize;
        int persistenceNum;

        private LogFileParams() {
        }
    }
}

