/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.util.Log;
import com.qihoo.livecloud.tools.LogEntry;
import com.qihoo.livecloud.tools.LogUtil;
import java.util.Locale;

public class Logger {
    public static final String TAG = "Logger";
    private static final String CLASS_FILE_NAME = "Logger.java";
    public static final String CRASHTAG = "crash_log";
    public static boolean LOG_ENABLE = false;
    public static boolean LOG_WRITE_FILE_LOG_ENABLE = false;

    public static void enable() {
        LOG_ENABLE = true;
    }

    public static void disable() {
        LOG_ENABLE = false;
    }

    private static String createLog(StackTraceElement[] sElements, String log) {
        if (sElements == null || sElements.length < 1) {
            return "";
        }
        String className = sElements[1].getFileName();
        String methodName = sElements[1].getMethodName();
        int lineNumber = sElements[1].getLineNumber();
        try {
            if (className != null && className.endsWith(CLASS_FILE_NAME) && sElements.length > 2) {
                className = sElements[2].getFileName();
                methodName = sElements[2].getMethodName();
                lineNumber = sElements[2].getLineNumber();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(methodName);
        buffer.append(":");
        buffer.append(lineNumber);
        buffer.append("] ");
        buffer.append(log);
        return buffer.toString();
    }

    private static String getClassName(StackTraceElement[] sElements) {
        if (sElements == null || sElements.length < 1) {
            return "";
        }
        String className = sElements[1].getFileName();
        try {
            if (className != null && className.endsWith(CLASS_FILE_NAME) && sElements.length > 2) {
                className = sElements[2].getFileName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return className;
    }

    public static void v(String tag, String message) {
        if (!LOG_ENABLE) {
            return;
        }
        StackTraceElement[] elements = new Throwable().getStackTrace();
        String msg = Logger.createLog(elements, message);
        Log.v((String)Logger.getClassName(elements), (String)msg);
        LogUtil.log(tag, msg, new Object[0]);
    }

    public static void v(String tag, String format, Object ... args) {
        if (!LOG_ENABLE) {
            return;
        }
        Logger.v(tag, String.format(Locale.US, format, args));
    }

    public static void d(String tag, String message) {
        if (!LOG_ENABLE) {
            return;
        }
        StackTraceElement[] elements = new Throwable().getStackTrace();
        String msg = Logger.createLog(elements, message);
        Log.d((String)Logger.getClassName(elements), (String)msg);
        LogUtil.log(tag, msg, new Object[0]);
    }

    public static void d(String tag, String fmt, Object ... args) {
        if (!LOG_ENABLE) {
            return;
        }
        Logger.d(tag, String.format(Locale.US, fmt, args));
    }

    public static void d(String tag, String message, Throwable tr) {
        if (!LOG_ENABLE) {
            return;
        }
        Log.d((String)TAG, (String)("[ " + tag + " ] " + message), (Throwable)tr);
    }

    public static void i(String tag, String message) {
        if (!LOG_ENABLE) {
            return;
        }
        StackTraceElement[] elements = new Throwable().getStackTrace();
        String msg = Logger.createLog(elements, message);
        Log.i((String)Logger.getClassName(elements), (String)msg);
        LogUtil.log(tag, msg, new Object[0]);
    }

    public static void i(String tag, String fmt, Object ... args) {
        if (!LOG_ENABLE) {
            return;
        }
        Logger.i(tag, String.format(Locale.US, fmt, args));
    }

    public static void w(String tag, String message) {
        if (!LOG_ENABLE) {
            return;
        }
        StackTraceElement[] elements = new Throwable().getStackTrace();
        String msg = Logger.createLog(elements, message);
        Log.w((String)Logger.getClassName(elements), (String)msg);
        LogUtil.log(tag, msg, new Object[0]);
    }

    public static void w(String tag, String fmt, Object ... args) {
        if (!LOG_ENABLE) {
            return;
        }
        Logger.w(tag, String.format(Locale.US, fmt, args));
    }

    public static void e(String tag, String message) {
        if (!LOG_ENABLE) {
            return;
        }
        StackTraceElement[] elements = new Throwable().getStackTrace();
        String msg = Logger.createLog(elements, message);
        Log.e((String)Logger.getClassName(elements), (String)msg);
        LogUtil.log(tag, msg, new Object[0]);
    }

    public static void e(String tag, String fmt, Object ... args) {
        if (!LOG_ENABLE) {
            return;
        }
        Logger.e(tag, String.format(Locale.US, fmt, args));
    }

    public static void f(int id, int level, String tag, String message) {
        if (LOG_WRITE_FILE_LOG_ENABLE) {
            LogEntry.logFile(id, level, "[%s] %s", tag, message);
        }
    }

    public static void f(int id, int level, String tag, String fmt, Object ... args) {
        Logger.f(id, level, tag, String.format(fmt, args));
    }

    public static void iif(int id, String tag, String message) {
        Logger.i(tag, message);
        Logger.f(id, 2, tag, message);
    }

    public static void iif(int id, String tag, String fmt, Object ... args) {
        Logger.i(tag, fmt, args);
        Logger.f(id, 2, tag, fmt, args);
    }

    public static void ef(int id, String tag, String message) {
        Logger.e(tag, message);
        Logger.f(id, 4, tag, message);
    }

    public static void ef(int id, String tag, String fmt, Object ... args) {
        Logger.e(tag, fmt, args);
        Logger.f(id, 4, tag, fmt, args);
    }
}

