/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.qihoo.livecloud.tools.Logger;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.List;

public class NetUtil {
    public static final int NETWORK_TYPE_INVALID = 0;
    public static final int NETWORK_TYPE_WAP = 1;
    public static final int NETWORK_TYPE_2G = 2;
    public static final int NETWORK_TYPE_3G = 3;
    public static final int NETWORK_TYPE_4G = 5;
    public static final int NETWORK_TYPE_WIFI = 4;

    public static String getNetWorkTypeToString(Context context) {
        switch (NetUtil.getNetWorkType(context)) {
            case 4: {
                return "wifi";
            }
            case 1: {
                return "wap";
            }
            case 2: {
                return "2g";
            }
            case 3: {
                return "3g";
            }
            case 5: {
                return "4g";
            }
        }
        return "unkown";
    }

    public static int getNetWorkType(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            String type = networkInfo.getTypeName();
            if (type.equalsIgnoreCase("WIFI")) {
                return 4;
            }
            if (type.equalsIgnoreCase("MOBILE")) {
                String proxyHost = Proxy.getDefaultHost();
                int mobile = 2;
                switch (NetUtil.isFastMobileNetwork(context)) {
                    case 0: {
                        mobile = 2;
                        break;
                    }
                    case 1: {
                        mobile = 3;
                        break;
                    }
                    case 2: {
                        mobile = 5;
                    }
                }
                return proxyHost == null || proxyHost.length() == 0 ? mobile : 1;
            }
        }
        return 0;
    }

    public static int isFastMobileNetwork(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        switch (telephonyManager.getNetworkType()) {
            case 7: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 8: {
                return 1;
            }
            case 10: {
                return 1;
            }
            case 9: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 14: {
                return 1;
            }
            case 12: {
                return 1;
            }
            case 15: {
                return 1;
            }
            case 11: {
                return 0;
            }
            case 13: {
                return 2;
            }
            case 0: {
                return 0;
            }
        }
        return 0;
    }

    public static NetworkInfo getNetworkInfo(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo ret = null;
        try {
            ret = cm.getActiveNetworkInfo();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static boolean isConnected(Context context) {
        NetworkInfo info = NetUtil.getNetworkInfo(context);
        return info != null && info.isConnected();
    }

    public static boolean isConnectedOrConnecting(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
        return networkInfo != null && networkInfo.isConnectedOrConnecting();
    }

    public static boolean isAvailable(Context context) {
        NetworkInfo info = NetUtil.getNetworkInfo(context);
        return info != null && info.isAvailable();
    }

    public static boolean isConnectedWifi(Context context) {
        NetworkInfo info = NetUtil.getNetworkInfo(context);
        return info != null && info.isConnected() && info.getType() == 1;
    }

    public static boolean isConnectedMobile(Context context) {
        NetworkInfo info = NetUtil.getNetworkInfo(context);
        return info != null && info.isConnected() && info.getType() == 0;
    }

    public static String getNetworkTypeName(Context context) {
        String type = "";
        NetworkInfo info = NetUtil.getNetworkInfo(context);
        if (info != null && info.isConnected()) {
            type = info.getTypeName();
        }
        return type;
    }

    public static String getNetworkExtraInfo(Context context) {
        String extra = "";
        NetworkInfo info = NetUtil.getNetworkInfo(context);
        if (info != null && info.isConnected()) {
            extra = info.getExtraInfo();
        }
        return extra;
    }

    public static boolean isConnectedFast(Context context) {
        NetworkInfo info = NetUtil.getNetworkInfo(context);
        return info != null && info.isConnected() && NetUtil.isConnectionFast(info.getType(), info.getSubtype());
    }

    public static boolean isConnectionFast(int type, int subType) {
        if (type == 1) {
            return true;
        }
        if (type == 0) {
            switch (subType) {
                case 7: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 8: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 11: {
                    return false;
                }
                case 13: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static String getLocalWifiAddress(Context context) {
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        if (wifiManager.isWifiEnabled()) {
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            int ipAddress = wifiInfo.getIpAddress();
            String ip = NetUtil.intToIp(ipAddress);
            return ip;
        }
        return "127.0.0.1";
    }

    public static boolean isWifiEnabled(Context context) {
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        return wifiManager.isWifiEnabled();
    }

    public static String getWiFiMacaddress(Context context) {
        WifiInfo info;
        String macAddress = null;
        WifiManager wifiMgr = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        WifiInfo wifiInfo = info = null == wifiMgr ? null : wifiMgr.getConnectionInfo();
        if (null != info) {
            macAddress = info.getMacAddress();
        }
        return macAddress;
    }

    public static String getWifiBSSID(Context context) {
        WifiManager wifiMgr = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        WifiInfo info = null;
        try {
            info = null == wifiMgr ? null : wifiMgr.getConnectionInfo();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return info == null ? null : info.getBSSID();
    }

    public static String getLocalAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isWifiApEnabled(Context context) {
        try {
            WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            Method method = wifiManager.getClass().getMethod("getWifiApState", new Class[0]);
            int s = (Integer)method.invoke((Object)wifiManager, new Object[0]);
            if (s > 10) {
                s -= 10;
            }
            return s == 2 || s == 3;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static WifiConfiguration getWifiApConfig(Context context) {
        try {
            WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            Method method = wifiManager.getClass().getMethod("getWifiApConfiguration", new Class[0]);
            return (WifiConfiguration)method.invoke((Object)wifiManager, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String intToIp(int i) {
        return (i & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 24 & 0xFF);
    }

    public static String getCurrentSsid(Context context) {
        WifiManager wifiManager;
        WifiInfo connectionInfo;
        String ssid = "";
        ConnectivityManager connManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connManager.getNetworkInfo(1);
        if (networkInfo.isConnectedOrConnecting() && (connectionInfo = (wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi")).getConnectionInfo()) != null && connectionInfo.getSSID() != null && !connectionInfo.getSSID().equals("") && !TextUtils.isEmpty((CharSequence)(ssid = connectionInfo.getSSID())) && ssid.charAt(0) == '\"' && ssid.charAt(ssid.length() - 1) == '\"') {
            ssid = ssid.substring(1, ssid.length() - 1);
        }
        return ssid;
    }

    public static boolean getMobileDataEnabled(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        try {
            Class<?> targetClass = connectivityManager.getClass();
            Method getMobileDataEnabledMethod = targetClass.getDeclaredMethod("getMobileDataEnabled", new Class[0]);
            getMobileDataEnabledMethod.setAccessible(true);
            boolean flg = (Boolean)getMobileDataEnabledMethod.invoke((Object)connectivityManager, new Object[0]);
            return flg;
        }
        catch (Exception e) {
            Logger.e("fu", "error" + e);
            return false;
        }
    }

    public static boolean setMobileDataEnabled(Context context, boolean enabled) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        try {
            Class<?> targetClass = connectivityManager.getClass();
            Method setMobileDataEnabledMethod = targetClass.getDeclaredMethod("setMobileDataEnabled", Boolean.TYPE);
            setMobileDataEnabledMethod.setAccessible(true);
            setMobileDataEnabledMethod.invoke((Object)connectivityManager, enabled);
            return true;
        }
        catch (Exception e) {
            Logger.e("fu", "error setMobileDataEnabled" + e);
            return false;
        }
    }

    public static boolean isHasSim(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
        if (Build.VERSION.SDK_INT >= 21) {
            return 0 == manager.getPhoneType();
        }
        return 1 == manager.getSimState();
    }

    public static boolean isNetworkConnected(Context ctx) {
        boolean isConnected = false;
        try {
            ConnectivityManager manager = (ConnectivityManager)ctx.getApplicationContext().getSystemService("connectivity");
            NetworkInfo networks = manager.getActiveNetworkInfo();
            if (networks != null) {
                isConnected = networks.isConnected();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isConnected;
    }

    public static void disableAllNetwork(Context context) {
        final Context ctx = context.getApplicationContext();
        if (!NetUtil.isConnectedWifi(ctx)) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                WifiManager wifiManager = (WifiManager)ctx.getSystemService("wifi");
                wifiManager.disconnect();
                List allConfigs = null;
                try {
                    allConfigs = wifiManager.getConfiguredNetworks();
                    for (WifiConfiguration config : allConfigs) {
                        if (config == null) continue;
                        wifiManager.disableNetwork(config.networkId);
                    }
                    wifiManager.saveConfiguration();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }).start();
    }
}

