/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.content.Context;
import com.qihoo.livecloud.plugin.ILiveCloudPlugin;
import com.qihoo.livecloud.tools.LocalSoLoadManager;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.RunnableManager;
import com.qihoo.livecloud.tools.SoErrorReport;
import com.qihoo.livecloud.tools.Stats;

public class QHVCToolsPlugin
extends ILiveCloudPlugin {
    private static QHVCToolsPlugin sInstance = null;

    protected QHVCToolsPlugin() {
        super("tools", Stats.getVersion(), "2.0.2.0", 478906L);
    }

    public static synchronized QHVCToolsPlugin getInstance() {
        if (sInstance == null) {
            sInstance = new QHVCToolsPlugin();
            if (!Stats.isSoLoaded()) {
                sInstance.setDefaultPluginInstalled(false);
            } else if (sInstance.isPluginInstalled()) {
                sInstance.loadPlugin();
            }
        }
        return sInstance;
    }

    @Override
    public int loadPlugin() {
        int ret = super.loadPlugin();
        if (ret == 0) {
            boolean isSoLoaded = Stats.isSoLoaded();
            if (isSoLoaded) {
                RunnableManager.getInstance().runAll();
                return ret;
            }
            Logger.d("LiveCloudPlugin", "tools library load faild when getversion");
            SoErrorReport.report("pluginToolsLoadSo", 11, false, false);
            return 11;
        }
        return ret;
    }

    @Override
    public int checkInstallPlugin(Context context, ILiveCloudPlugin.PluginDownloadListener listener, final ILiveCloudPlugin.PluginCallback callback) {
        ILiveCloudPlugin.PluginCallback pluginCallbackProxy = new ILiveCloudPlugin.PluginCallback(){

            @Override
            public void onStart(Context context) {
                if (callback != null) {
                    callback.onStart(context);
                }
            }

            @Override
            public void onProgress(Context context, int progress) {
                if (callback != null) {
                    callback.onProgress(context, progress);
                }
            }

            @Override
            public void onComplete(Context context, boolean background, int result) {
                if (result == 0) {
                    int loadResult = QHVCToolsPlugin.this.loadPlugin();
                    if (loadResult == 0) {
                        Logger.d("LiveCloudPlugin", "proxy tools library load success");
                    } else {
                        Logger.e("LiveCloudPlugin", "proxy tools library load failed, ret=" + loadResult);
                    }
                } else {
                    Logger.e("LiveCloudPlugin", "proxy tools library download failed, ret=" + result);
                }
                if (callback != null) {
                    callback.onComplete(context, background, result);
                }
            }

            @Override
            public void onCancel(Context context) {
                if (callback != null) {
                    callback.onCancel(context);
                }
            }
        };
        return super.checkInstallPlugin(context, null, pluginCallbackProxy);
    }

    @Override
    public void setDefaultPluginInstalled(boolean defaultPluginInstalled) {
        if (!defaultPluginInstalled) {
            LocalSoLoadManager.getInstance().cancelLoadSo("transcore");
        }
        super.setDefaultPluginInstalled(defaultPluginInstalled);
    }
}

