/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.getkeepsafe.relinker.livecloud.ReLinker;
import com.qihoo.livecloud.tools.LogEntry;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.MD5;
import com.qihoo.livecloud.tools.SoErrorReport;
import java.lang.reflect.Method;

public class SDKUtils {
    private static final String DEFAULT = "default";

    public static boolean loadLibrary(String libraryName) {
        try {
            Logger.d("loadLibrary", "loadLibrary : " + libraryName);
            System.loadLibrary(libraryName);
            return true;
        }
        catch (Throwable e) {
            Logger.e("loadLibrary", "loadLibrary %s : %s", libraryName, e.getMessage());
            if (!TextUtils.isEmpty((CharSequence)libraryName) && libraryName.compareToIgnoreCase("transcore") == 0) {
                SoErrorReport.report("LogEntryLoadLibrary", -1, false, true);
            }
            return false;
        }
    }

    public static boolean loadLibrary(Context context, String libraryName) {
        try {
            Logger.d("loadLibrary", "relinker context=" + context + ", loadLibrary : " + libraryName);
            if (context != null) {
                ReLinker.loadLibrary(context, libraryName);
            } else {
                System.loadLibrary(libraryName);
            }
            return true;
        }
        catch (Throwable e) {
            Logger.ef(LogEntry.logGetTransportId(), "loadLibrary", "relinker loadLibrary %s : %s", libraryName, e.getMessage());
            if (!TextUtils.isEmpty((CharSequence)libraryName) && libraryName.compareToIgnoreCase("transcore") == 0) {
                SoErrorReport.report("LogEntryLoadLibrary", -1, context != null, true);
            }
            return false;
        }
    }

    public static String getM2(Context context) {
        try {
            String m2 = MD5.encryptMD5(SDKUtils.getDeviceId1(context) + SDKUtils.getAndroidId(context) + SDKUtils.getSerialNo());
            return m2;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static String getDeviceId1(Context context) {
        String deviceId = null;
        if (context != null && TextUtils.isEmpty((CharSequence)(deviceId = SDKUtils.getImei(context)))) {
            deviceId = SDKUtils.getWifiMac(context);
        }
        deviceId = TextUtils.isEmpty(deviceId) ? DEFAULT : deviceId;
        return deviceId;
    }

    public static String getImei(Context context) {
        String imei = null;
        if (context != null) {
            TelephonyManager telManager = (TelephonyManager)context.getSystemService("phone");
            try {
                if (telManager != null) {
                    imei = telManager.getDeviceId();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return imei;
    }

    public static String getWifiMac(Context context) {
        String macAddr = null;
        if (context != null) {
            try {
                WifiInfo wifiInfo;
                WifiManager wifiMgr = (WifiManager)context.getSystemService("wifi");
                if (wifiMgr != null && (wifiInfo = wifiMgr.getConnectionInfo()) != null) {
                    macAddr = wifiInfo.getMacAddress();
                }
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return macAddr;
    }

    public static String getAndroidId(Context context) {
        String androidId = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return androidId;
    }

    public static String getSerialNo() {
        String sNo = null;
        try {
            Class<?> localClass = Class.forName("android.os.SystemProperties");
            Method localMethod = localClass.getMethod("get", String.class);
            sNo = (String)localMethod.invoke(localClass, "ro.serialno");
        }
        catch (Exception localException) {
            sNo = "";
        }
        return sNo;
    }
}

