/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.text.TextUtils;
import com.qihoo.livecloud.tools.LocalSoLoadManager;
import com.qihoo.livecloud.tools.LogEntry;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.ScheduleCallBack;
import com.qihoo.livecloud.tools.ServerAddrs;
import java.util.Hashtable;

public class Schedule {
    public static final String TAG = "Schedule";
    public static final String DEFULT_EMPTY = "";
    public static final String ENCODE_TYPE_H265 = "h265";
    public static final String ENCODE_TYPE_H264 = "h264";
    public static final String RATE_TYPE_SD = "sd";
    public static final String RATE_TYPE_HD = "hd";
    public static final String RATE_TYPE_XD = "xd";
    private static Hashtable<String, ScheduleCallBack> callBackList = null;
    private static ScheduleCallBack scheduleCallBack = new ScheduleCallBack(){

        @Override
        public void scheduleState(int event, int errCode, String sid, ServerAddrs serverAddrs) {
            ScheduleCallBack call;
            if (callBackList != null && (call = (ScheduleCallBack)callBackList.get(sid)) != null) {
                call.scheduleState(event, errCode, sid, serverAddrs);
            }
        }
    };

    private static native boolean schedulepredoscheduling(String var0, int var1, int var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10);

    private static native boolean scheduledoscheduling(String var0, String var1, int var2, String var3, String var4, int var5, int var6, String var7, String var8, String var9, String var10, String var11, String var12, ScheduleCallBack var13);

    private static native void scheduledestroy(String var0);

    private static native boolean scheduleisnecessary(String var0);

    public static boolean schedulePreDoscheduling(int delay, String sn, String cid, String uid, String net, String sign) {
        String uri = "http://g2.live.360.cn/";
        if (!TextUtils.isEmpty((CharSequence)cid) && !cid.contains("huajiao")) {
            uri = "http://g.live.360.cn/";
        }
        Logger.iif(LogEntry.logGetTransportId(), TAG, "schedulePreDoscheduling cid : " + cid + " uri : " + uri + " uid : " + uid + " sn : " + sn + " sign : " + sign + " net : " + net);
        return Schedule.schedulepredoscheduling(uri, delay, 1, Schedule.checkParam(sn), Schedule.checkParam(cid), Schedule.checkParam(uid), Schedule.checkParam(net), Schedule.checkParam(sign), ENCODE_TYPE_H265, RATE_TYPE_SD, "all");
    }

    public static boolean schedulePreDoscheduling(String uri, int delay, String sn, String cid, String uid, String net, String sign) {
        Logger.iif(LogEntry.logGetTransportId(), TAG, "schedulePreDoscheduling uri=" + uri + "cid : " + cid + " uri : " + uri + " uid : " + uid + " sn : " + sn + " sign : " + sign + " net : " + net);
        return Schedule.schedulepredoscheduling(uri, delay, 1, Schedule.checkParam(sn), Schedule.checkParam(cid), Schedule.checkParam(uid), Schedule.checkParam(net), Schedule.checkParam(sign), ENCODE_TYPE_H265, RATE_TYPE_SD, "all");
    }

    public static boolean scheduleDoscheduling(String sid, String uri, int delay, String rtc, String userData, int type, int proto, String ssn, String pksn, String sign, String encodeType, String rateType, String streamType, ScheduleCallBack callback) {
        if (callBackList == null) {
            callBackList = new Hashtable();
        }
        if (callback != null) {
            callBackList.put(sid, callback);
        }
        return Schedule.scheduledoscheduling(Schedule.checkParam(sid), Schedule.checkParam(uri), delay, rtc, Schedule.checkParam(userData), type, proto, Schedule.checkParam(ssn), Schedule.checkParam(pksn), Schedule.checkParam(sign), Schedule.checkParam(encodeType), Schedule.checkParam(rateType), Schedule.checkParam(streamType), scheduleCallBack);
    }

    public static void scheduleDestroy(String sid) {
        ScheduleCallBack call;
        if (callBackList != null && (call = callBackList.get(sid)) != null) {
            call = null;
            callBackList.remove(sid);
        }
        Schedule.scheduledestroy(sid);
    }

    public static boolean scheduleIsNecessary(String sn) {
        return Schedule.scheduleisnecessary(sn);
    }

    private static synchronized String checkParam(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return DEFULT_EMPTY;
        }
        return value;
    }

    static {
        LocalSoLoadManager.getInstance().loadSo("transcore");
    }
}

