/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.text.TextUtils;
import com.qihoo.livecloud.plugin.core.PluginAbiHelper;
import com.qihoo.livecloud.plugin.core.PluginConfig;
import com.qihoo.livecloud.plugin.core.PluginDownloadHelper;
import com.qihoo.livecloud.tools.MD5;
import com.qihoo.livecloud.tools.QHVCToolsPlugin;
import com.qihoo.livecloud.tools.Stats;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class SoErrorReport {
    static String TAG = "SoErrorReport";
    public static final String KEY_STATS_LOADLIBARAY = "StatsloadLibrary";
    public static final String KEY_GPWEBRTCSETTING_LOADLIBARAY = "GPWebrtcSettingsLoadLibrary";
    public static final String KEY_LOGENTRY_LOADLIBARAY = "LogEntryLoadLibrary";
    public static final String KEY_CORE_ON_APP_START = "coreOnAppStart";
    public static final String KEY_LOG_START = "logstart";
    public static final String KEY_LOG_SET_LOGPATH = "logsetlogpath";
    public static final String KEY_LOG_SET_LOG_DISPLAY = "logsetlogdisplay";
    public static final String KEY_PLUGIN_LAOD_INSTALLED_SO = "pluinLoadInstalledSo";
    public static final String KEY_PLUGIN_DOWNLOAD_AND_LOAD_SO = "pluinDownloadAndLoadSo";
    public static final String KEY_PLUGIN_DOWNLOAD_FAILED = "pluinDownloadFailed";
    public static final String KEY_PLUGIN_TOOLS_LOAD_SO = "pluginToolsLoadSo";
    public static final String KEY_PLUGIN_DOWNLOAD_CONFIG = "pluginDownloadConfig";
    public static final String KEY_PLUGIN_DOWNLOAD_ZIP = "pluginDownloadZip";
    public static final String KEY_PLUGIN_CHECKSOINAPK = "checkSoInApk";
    public static final String KEY_PLUGIN_DECIPHERING = "deciphering";

    public static void report(String key, int error, boolean relink, boolean staticLoad) {
        SoErrorReport.report(key, error, relink, staticLoad, null);
    }

    public static void report(String key, int error, boolean relink, boolean staticLoad, Map<String, String> otherParams) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("module", "tools");
            params.put("sdk_ver", Stats.getVersion());
            QHVCToolsPlugin qhvcToolsPlugin = QHVCToolsPlugin.getInstance();
            if (qhvcToolsPlugin.isDefaultPluginInstalled()) {
                params.put("soinapk", "1");
            } else {
                if (staticLoad) {
                    return;
                }
                boolean isInstall = qhvcToolsPlugin.isPluginInstalled();
                params.put("isInstall", isInstall ? "1" : "0");
                if (isInstall) {
                    params.put("pluginver", qhvcToolsPlugin.getPluginVersion());
                }
            }
            String[] abi = PluginAbiHelper.getSystemSupportAbis();
            String abiList = "";
            if (abi != null) {
                for (int i = 0; i < abi.length; ++i) {
                    abiList = abiList + abi[i];
                    abiList = abiList + ".";
                }
            }
            params.put("sover", Stats.getNativeVersion());
            params.put("fkey", key);
            params.put("relink", relink ? "1" : "0");
            params.put("abi", abiList);
            params.put("filesAttri", SoErrorReport.getFilesAttri());
            try {
                String path = PluginDownloadHelper.getPluginDir("tools") + "/libtranscore.so";
                File file = new File(path);
                if (file.exists()) {
                    params.put("libmd5", MD5.encryptMD5(file));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (otherParams != null) {
                params.putAll(otherParams);
            }
            Stats.notifyWithoutJni("debug", "soload", "405", error, params);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFilesAttri() {
        String info = "";
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String dir = PluginConfig.getAppContext().getFilesDir().getParentFile().getAbsolutePath();
            Process process = Runtime.getRuntime().exec("ls  -l " + dir);
            inputStreamReader = new InputStreamReader(process.getInputStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (TextUtils.isEmpty((CharSequence)line) || !line.contains("files")) continue;
                info = line.substring(0, 10);
                break;
            }
        }
        catch (Throwable e) {
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        return info;
    }
}

