/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.content.Context;
import com.qihoo.livecloud.plugin.ILiveCloudPlugin;
import com.qihoo.livecloud.tools.LocalSoLoadManager;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.QHVCToolsPlugin;
import com.qihoo.livecloud.tools.RunnableManager;
import com.qihoo.livecloud.tools.SoErrorReport;
import com.qihoo.livecloud.tools.Stats;

public class SoLoadTool {
    static String TAG = "LiveCloudPlugin";
    private static boolean mLibraryLoaded = false;

    public static boolean isSoLoaded() {
        if (!mLibraryLoaded) {
            mLibraryLoaded = Stats.isSoLoaded();
        }
        return mLibraryLoaded;
    }

    public static void verifyLibrary(Context context) {
        if (SoLoadTool.isSoLoaded()) {
            RunnableManager.getInstance().runAll();
            return;
        }
        LocalSoLoadManager.getInstance().loadSoSync("transcore");
        if (SoLoadTool.isSoLoaded()) {
            RunnableManager.getInstance().runAll();
            return;
        }
        final QHVCToolsPlugin qhvcToolsPlugin = QHVCToolsPlugin.getInstance();
        qhvcToolsPlugin.setDefaultPluginInstalled(mLibraryLoaded);
        if (mLibraryLoaded) {
            Logger.d(TAG, "tools library exist");
        } else if (qhvcToolsPlugin.isPluginInstalled()) {
            int ret = qhvcToolsPlugin.loadPlugin();
            if (ret == 0) {
                mLibraryLoaded = true;
                Logger.d(TAG, "tools library load success");
            } else {
                Logger.e(TAG, "tools library load failed, ret=" + ret);
                SoErrorReport.report("pluinLoadInstalledSo", ret, false, false);
            }
        } else {
            qhvcToolsPlugin.checkInstallPlugin(context, new ILiveCloudPlugin.PluginCallback(){

                @Override
                public void onStart(Context context) {
                    Logger.d(TAG, "tools library download start");
                }

                @Override
                public void onProgress(Context context, int progress) {
                    Logger.d(TAG, "tools library download progress, progress=" + progress);
                }

                @Override
                public void onComplete(Context context, boolean background, int result) {
                    Logger.i(TAG, "tools library download complete, background: " + background + ", result: " + result);
                    if (result == 0) {
                        int loadResult = qhvcToolsPlugin.loadPlugin();
                        if (loadResult == 0) {
                            mLibraryLoaded = true;
                            Logger.d(TAG, "tools library load success");
                        } else {
                            Logger.e(TAG, "tools library load failed, ret=" + loadResult);
                            SoErrorReport.report("pluinDownloadAndLoadSo", loadResult, false, false);
                        }
                    } else {
                        Logger.e(TAG, "tools library download failed, ret=" + result);
                        SoErrorReport.report("pluinDownloadFailed", result, false, false);
                    }
                }

                @Override
                public void onCancel(Context context) {
                    Logger.d(TAG, "tools library download cancel");
                }
            });
        }
    }
}

