/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.content.Context;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import com.gpsoft.bp.GPBreakPad;
import com.qihoo.livecloud.network.LCHttpGet;
import com.qihoo.livecloud.network.NetworkStateMonitor;
import com.qihoo.livecloud.settings.GPWebrtcSettings;
import com.qihoo.livecloud.tools.CloudControlManager;
import com.qihoo.livecloud.tools.CloudControlTrans;
import com.qihoo.livecloud.tools.CodecConfig;
import com.qihoo.livecloud.tools.LocalSoLoadManager;
import com.qihoo.livecloud.tools.LogEntry;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.MD5;
import com.qihoo.livecloud.tools.NetUtil;
import com.qihoo.livecloud.tools.RunnableManager;
import com.qihoo.livecloud.tools.SoErrorReport;
import com.qihoo.livecloud.tools.StatsRtcCallback;
import com.qihoo.livecloud.tools.UploadDataInfo;
import com.qihoo.livecloud.tools.UrlSafeEncode;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class Stats {
    public static final String TAG = "LiveCloud_Stats";
    public static final String DEFULT_EMPTY = "";
    public static final int NC_TYPE_TOWIFI = 0;
    public static final int NC_TYPE_OTHERS = 1;
    private static Context mContext;
    private static String mBid;
    private static String mAppVer;
    private static String mMid;
    private static boolean mJniInit;
    public static final String SESSION_PARAM_MODULE = "module";
    public static final String SESSION_PARAM_MODULE_VERSION = "sdk_ver";
    public static final String SESSION_PARAM_APP_PACKANGE_NAME = "package";
    public static final String SESSION_PARAM_SO_VERSION = "so_ver";
    private static final String VERSION = "2.0.3.18041001";

    public static Context getContext() {
        return mContext;
    }

    public static String getBid() {
        return mBid;
    }

    private static void loadLibrary() {
        LocalSoLoadManager.getInstance().loadSo("transcore");
    }

    private static native void notifygpszoneinfo(double var0, double var2);

    private static native void networkchange(int var0);

    private static native void notifytriggercloud(String var0, String var1);

    private static native void notifyappstart(String var0, String var1, String var2, String var3, String var4, String var5, Map<String, Object> var6);

    private static native void setnotifyurl(String var0, String var1, String var2, String var3);

    private static native void setuploaddefaultdomainnames(String var0);

    private static native void userstart(String var0, String var1, String var2, String var3, String var4, String var5);

    private static native void userstop(String var0);

    private static native void userdestroy(String var0);

    private static native void userbackground(String var0);

    private static native void userforeground(String var0);

    private static native void schedulestart(String var0);

    private static native void pubopen(String var0);

    private static native void pubdestroy(String var0);

    private static native void notifyshortvideoupload(String var0);

    private static native void notifyuploaddata(String var0, int var1, UploadDataInfo var2);

    private static native void notifycommonstat(String var0, String var1, int var2, int var3, String var4);

    private static native String getversion();

    private static native void notifycpugpustatus(double var0, double var2);

    private static native void notifywifiquality(int var0);

    private static native void notifyrtcstreamstatus(String var0, String var1, StatsRtcCallback var2);

    private static native void notifyrtcmergestreamstatus(String var0, String var1, StatsRtcCallback var2);

    private static native void coreonappstart(String var0, String var1, String var2, String var3, String var4, String var5, String var6, Map<String, Object> var7);

    private static native void coreopenudxlib(String var0);

    private static native void coreopenlualib(String var0);

    public static native String getak();

    public static native String getsk();

    private static native int setcloudcontroltrans(CloudControlTrans var0);

    private static native void notifysetnetworktype(String var0);

    public static void notifyGpsZoneInfo(double longitude, double latitude) {
        if (Logger.LOG_ENABLE) {
            Logger.d(TAG, "notifyGpsZoneInfo longitude : " + longitude + ", latitude : " + latitude);
        }
        Stats.notifygpszoneinfo(longitude, latitude);
    }

    public static void networkChange(int type) {
        Stats.networkchange(type);
    }

    public static void notifyTriggerCloud(String bid, String ver) {
        if (Logger.LOG_ENABLE) {
            Logger.d(TAG, "notifyTriggerCloud bid : " + bid + " ver : " + ver);
        }
        CloudControlManager.getInstance().updateConfig();
    }

    @Deprecated
    public static void notifyAppStart(Context context, String bid, String ver, String os, String mid, String urlCc) {
        mContext = context.getApplicationContext();
        Stats.loadLibrary();
        os = os + "_" + Build.BRAND + "_" + Build.MODEL;
        Logger.iif(LogEntry.logGetTransportId(), TAG, "notifyAppStart bid : " + bid + " ver : " + ver + " os : " + os + " mid : " + mid + " urlCc : " + urlCc);
        Stats.setCodecInfo(bid, ver, mid, urlCc);
        Stats.notifyappstart(Stats.checkParam(bid), "ANDROID", Stats.checkParam(ver), Stats.checkParam(os), Stats.checkParam(mid), Stats.checkParam(urlCc), null);
    }

    private static void setCodecInfo(String bid, String ver, String mid, String urlCc) {
        CodecConfig.getInstance().setBid(bid);
        CodecConfig.getInstance().setVer(ver);
        CodecConfig.getInstance().setMid(mid);
        CodecConfig.getInstance().setUrlCc(urlCc);
        CodecConfig.getInstance().getCodecConfigFromServer();
    }

    public static void test_setNotifyUrl(String url, String urlFB, String urlMicFB, String urlCC) {
        if (Logger.LOG_ENABLE) {
            Logger.d(TAG, "test_setNotifyUrl url : " + url + " urlFB=" + urlFB + " urlMicFB: " + urlMicFB + " urlCc : " + urlCC);
        }
        class SetNotifyUrlRunnable
        implements Runnable {
            private String url;
            private String urlFB;
            private String urlMicFB;
            private String urlCC;

            SetNotifyUrlRunnable(String url, String urlFB, String urlMicFB, String urlCC) {
                this.url = url;
                this.urlFB = urlFB;
                this.urlMicFB = urlMicFB;
                this.urlCC = urlCC;
            }

            @Override
            public void run() {
                Logger.i(Stats.TAG, "test_setNotifyUrl: runnable run");
                CloudControlManager.getInstance().setConfigUrl(Stats.checkParam(this.urlCC));
                Stats.setnotifyurl(Stats.checkParam(this.url), Stats.checkParam(this.urlFB), Stats.checkParam(this.urlMicFB), Stats.checkParam(this.urlCC));
            }
        }
        SetNotifyUrlRunnable runnable = new SetNotifyUrlRunnable(url, urlFB, urlMicFB, urlCC);
        if (Stats.isSoLoaded()) {
            runnable.run();
        } else {
            Logger.i(TAG, "test_setNotifyUrl: no so");
            RunnableManager.getInstance().addRunnable(runnable);
        }
    }

    public static void test_setNotifyUrl(String url, String urlFB, String urlCC) {
        if (Logger.LOG_ENABLE) {
            Logger.d(TAG, "test_setNotifyUrl url : " + url + " urlFB=" + urlFB + " urlCc : " + urlCC);
        }
        Stats.setnotifyurl(Stats.checkParam(url), Stats.checkParam(urlFB), DEFULT_EMPTY, Stats.checkParam(urlCC));
    }

    public static void userStart(String sid, String uid, String cid, String net, String sn) {
    }

    public static void userStop(String sid) {
    }

    public static void userDestroy(String sid) {
    }

    public static boolean sessionStart(String sid, String uid, String cid, String net, String sn, Map<String, String> params) {
        if (!mJniInit || !Stats.isSoLoaded()) {
            return false;
        }
        Logger.iif(LogEntry.logGetTransportId(), TAG, "sessionStart sid : " + sid + " uid : " + uid + " net : " + net + " sn : " + sn);
        String param = DEFULT_EMPTY;
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                param = param + "&" + entry.getKey() + "=" + UrlSafeEncode.encode(entry.getValue());
                Logger.iif(LogEntry.logGetTransportId(), TAG, "sessionStart " + entry.getKey() + ": " + entry.getValue());
            }
        }
        if (mContext != null) {
            param = param + "&package=" + mContext.getPackageName();
        }
        Stats.userstart(Stats.checkParam(sid), Stats.checkParam(uid), Stats.checkParam(cid), Stats.checkParam(net), Stats.checkParam(sn), Stats.checkParam(param));
        return true;
    }

    public static void sessionStop(String sid) {
        if (!mJniInit || !Stats.isSoLoaded()) {
            return;
        }
        Logger.iif(LogEntry.logGetTransportId(), TAG, "sessionStop sid : " + sid);
        Stats.userstop(Stats.checkParam(sid));
    }

    public static void sessionDestroy(String sid) {
        if (!mJniInit || !Stats.isSoLoaded()) {
            return;
        }
        Logger.iif(LogEntry.logGetTransportId(), TAG, "sessionDestroy=" + sid);
        Stats.userdestroy(Stats.checkParam(sid));
    }

    public static void userBackground(String sid) {
        Logger.iif(LogEntry.logGetTransportId(), TAG, "userBackground sid : " + sid);
        Stats.userbackground(Stats.checkParam(sid));
    }

    public static void userForeground(String sid) {
        Logger.iif(LogEntry.logGetTransportId(), TAG, "userForeground sid : " + sid);
        Stats.userforeground(Stats.checkParam(sid));
    }

    public static void scheduleStart(String sid) {
        Logger.iif(LogEntry.logGetTransportId(), TAG, "scheduleStart sid : " + sid);
        Stats.schedulestart(Stats.checkParam(sid));
    }

    public static void pubOpen(String sid) {
        Logger.iif(LogEntry.logGetTransportId(), TAG, "pubOpen sid : " + sid);
        Stats.pubopen(Stats.checkParam(sid));
    }

    public static void pubDestroy(String sid) {
        Logger.iif(LogEntry.logGetTransportId(), TAG, "pubDestroy sid : " + sid);
        Stats.pubdestroy(Stats.checkParam(sid));
    }

    private static synchronized String checkParam(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return DEFULT_EMPTY;
        }
        return value;
    }

    public static void notifyShortvideoUpload(String info) {
        if (Logger.LOG_ENABLE) {
            Logger.d(TAG, "notifyShortvideoUpload info=" + info);
        }
        Stats.notifyshortvideoupload(info);
    }

    public static void notifyUploadData(String sid, int stageType, UploadDataInfo uploadDataInfo) {
        if (!mJniInit || !Stats.isSoLoaded()) {
            return;
        }
        if (Logger.LOG_ENABLE) {
            Logger.d(TAG, "LiveCloud_Stats, notifyUploadData sid=" + sid + " type=" + stageType);
            Logger.d(TAG, "LiveCloud_Stats, uploadDataInfo: " + uploadDataInfo.toString());
        }
        Stats.notifyuploaddata(sid, stageType, uploadDataInfo);
    }

    public static void notifyWithJniOrAndroid(String type, String businessSubID, String stage, int error, Map<String, String> params) {
        if (mJniInit && Stats.isSoLoaded()) {
            try {
                String sid = MD5.encryptMD5(String.valueOf(System.currentTimeMillis()) + String.valueOf(new Random().nextInt()));
                String net = NetUtil.getNetworkTypeName(Stats.getContext());
                Stats.sessionStart(sid, null, null, net, null, params);
                Stats.notifycommonstat(sid, businessSubID, Integer.valueOf(stage), error, DEFULT_EMPTY);
                Stats.sessionStop(sid);
                Stats.sessionDestroy(sid);
            }
            catch (Throwable e) {
                Stats.notifyWithoutJni(type, businessSubID, stage, error, params);
            }
        } else {
            Stats.notifyWithoutJni(type, businessSubID, stage, error, params);
        }
    }

    public static void notifyCommonStat(String sid, String businessSubID, int st, int error, String kvList) {
        if (!mJniInit || !Stats.isSoLoaded()) {
            return;
        }
        Stats.notifycommonstat(sid, businessSubID, st, error, kvList);
    }

    public static void notifyWithoutJni(String type, String businessSubID, String stage, int error, Map<String, String> params) {
        try {
            StringBuilder param = new StringBuilder();
            if (params != null) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    if (TextUtils.isEmpty((CharSequence)entry.getKey()) || TextUtils.isEmpty((CharSequence)entry.getValue())) continue;
                    param.append("&").append(entry.getKey()).append("=").append(UrlSafeEncode.encode(entry.getValue()));
                }
            }
            StringBuffer url = new StringBuffer();
            url.append("http://qos.live.360.cn/vc.gif?").append("&bid=").append(mBid).append("&pid=").append("android").append("&ver=").append(mAppVer).append("&c_ver=").append(Stats.getNativeVersion()).append("&os=").append(UrlSafeEncode.encode(Build.VERSION.RELEASE + "_" + Build.BRAND + "_" + Build.MODEL)).append("&mid=").append(mMid).append("&tm=").append(System.currentTimeMillis()).append("&r=").append(new Random().nextInt(Integer.MAX_VALUE)).append("&way=").append("pub").append("&pro=").append("non").append("&ty=").append(type).append("&bsid=").append(businessSubID).append("&st=").append(stage).append("&er=").append(error).append((CharSequence)param);
            if (mContext != null) {
                url.append("&package=").append(mContext.getPackageName());
            }
            Logger.d(TAG, "notifyWithoutJni " + url);
            new LCHttpGet(url.toString(), null, null).get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getNativeVersion() {
        String version = "0.0.0.0";
        try {
            version = Stats.getversion();
        }
        catch (Throwable e) {
            Logger.e(TAG, "LiveCloud_Stats, " + e.getMessage());
        }
        return version;
    }

    public static void notifyCpuGpuStatus(double cpuStatus, double gpuStatus) {
        if (Logger.LOG_ENABLE) {
            Logger.d(TAG, "notifyCpuGpuStatus cpuStatus=" + cpuStatus + " gpuStatus=" + gpuStatus);
        }
        Stats.notifycpugpustatus(cpuStatus, gpuStatus);
    }

    public static void notifyWifiQuality(int quality) {
        if (Logger.LOG_ENABLE) {
            Logger.d(TAG, "notifyWifiQuality quality=" + quality);
        }
        Stats.notifywifiquality(quality);
    }

    public static void notifyRtcStreamStatus(String sessionId, String kvList, StatsRtcCallback rtcCallback) {
        if (Logger.LOG_ENABLE) {
            Logger.d(TAG, "LiveCloud_Stats, notifyRtcStreamStatus  sessionId=" + sessionId + " kvList=" + kvList);
        }
        Stats.notifyrtcstreamstatus(Stats.checkParam(sessionId), Stats.checkParam(kvList), rtcCallback);
    }

    public static void notifyRtcMergeStreamStatus(String sessionId, String kvList, StatsRtcCallback rtcMergeStreamCallback) {
        if (Logger.LOG_ENABLE) {
            Logger.d(TAG, "LiveCloud_Stats, notifyRtcMergeStreamStatus  sessionId=" + sessionId + " kvList=" + kvList);
        }
        Stats.notifyrtcmergestreamstatus(Stats.checkParam(sessionId), Stats.checkParam(kvList), rtcMergeStreamCallback);
    }

    private static void coreOnAppStart(final String bid, final String ver, final String mid, String urlCc) {
        String pid = "android";
        String model = Build.BRAND + "_" + Build.MODEL;
        String os = Build.VERSION.RELEASE;
        os = os + "_" + model;
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogEntry.init(mContext, bid);
            }
        }).start();
        Logger.iif(LogEntry.logGetTransportId(), TAG, "coreOnAppStart bid=%s, ver=%s, mid=%s, urlCc=%s, os=%s", bid, ver, mid, urlCc, os);
        Stats.setCodecInfo(bid, ver, mid, urlCc);
        try {
            Stats.coreonappstart(Stats.checkParam(bid), pid, Stats.checkParam(ver), os, Stats.checkParam(mid), model, Stats.checkParam(urlCc), null);
        }
        catch (Throwable e) {
            SoErrorReport.report("coreOnAppStart", -1, false, false);
            throw e;
        }
        mJniInit = true;
        GPWebrtcSettings.getInstance().loadConfig();
        CloudControlManager.getInstance().loadConfig(mContext, urlCc, bid, ver, new CloudControlManager.updateConfigCallback(){

            @Override
            public void updateConfigFinish() {
                CloudControlTrans cloudControl = CloudControlTrans.fromJsonString(CloudControlManager.getInstance().getConfigJson());
                if (cloudControl != null) {
                    if (cloudControl.upload_dump != 0) {
                        Logger.d(Stats.TAG, "GPBreakPad. open upload dump.");
                        GPBreakPad.getInstance().init(mContext, bid, "ANDROID", ver, Stats.getVersion(), mid);
                    }
                    Logger.LOG_WRITE_FILE_LOG_ENABLE = cloudControl.write_file_log != 0;
                    Stats.setCloudControlTrans(cloudControl);
                }
            }
        });
        NetworkStateMonitor.getInstance().registerNetworkChangeListener(mContext, new NetworkStateMonitor.NetworkChangeListener(){

            @Override
            public void onNetworkChange(NetworkInfo networkInfo, String networkType) {
                if (networkInfo != null && networkInfo.isConnectedOrConnecting()) {
                    Logger.d(Stats.TAG, "LiveCloud_Stats, is connected, call networkChange!!");
                    Stats.networkChange(1);
                } else {
                    Logger.d(Stats.TAG, "LiveCloud_Stats, not connect");
                }
                if (!TextUtils.isEmpty((CharSequence)networkType)) {
                    Stats.notifySetNetworkType(networkType);
                }
            }
        });
    }

    public static void coreOnAppStart(Context context, String bid, String ver, String mid, String urlCc) {
        mContext = context.getApplicationContext();
        mBid = bid;
        mAppVer = ver;
        mMid = mid;
        Stats.loadLibrary();
        class StartRunnable
        implements Runnable {
            private String bid;
            private String ver;
            private String mid;
            private String urlCc;

            StartRunnable(String bid, String ver, String mid, String urlCc) {
                this.bid = bid;
                this.ver = ver;
                this.mid = mid;
                this.urlCc = urlCc;
            }

            @Override
            public void run() {
                Logger.i(Stats.TAG, "coreOnAppStart: runnable run");
                Stats.coreOnAppStart(this.bid, this.ver, this.mid, this.urlCc);
            }
        }
        StartRunnable runnable = new StartRunnable(bid, ver, mid, urlCc);
        if (Stats.isSoLoaded()) {
            runnable.run();
        } else {
            Logger.i(TAG, "coreOnAppStart: no so");
            RunnableManager.getInstance().addRunnable(runnable);
        }
    }

    public static boolean isSoLoaded() {
        if (!LocalSoLoadManager.isApkCheckFinish()) {
            return false;
        }
        boolean isSoLoaded = false;
        try {
            String ver = Stats.getversion();
            isSoLoaded = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isSoLoaded;
    }

    public static void coreOpenUdxLib(String path) {
        Stats.coreopenudxlib(path);
    }

    public static void coreOpenLuaLib(String path) {
        Stats.coreopenlualib(path);
    }

    public static void setUploadDefaultDomainNames(String url) {
        Stats.setuploaddefaultdomainnames(url);
    }

    public static int setCloudControlTrans(CloudControlTrans setting) {
        try {
            return Stats.setcloudcontroltrans(setting);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String decryptConfig(byte[] data) {
        return Stats.decrypt(data);
    }

    public static native String decrypt(byte[] var0);

    public static void notifySetNetworkType(String net) {
        Stats.notifysetnetworktype(net);
    }

    public static Map<String, String> getCommonUrlParam() {
        HashMap<String, String> kvMap = new HashMap<String, String>();
        try {
            StringBuffer os = new StringBuffer();
            os.append(Build.VERSION.RELEASE).append("_").append(Build.BRAND).append("_").append(Build.MODEL);
            kvMap.put("bid", mBid);
            kvMap.put("pid", "android");
            kvMap.put("ver", mAppVer);
            kvMap.put(SESSION_PARAM_MODULE_VERSION, Stats.getVersion());
            kvMap.put("c_ver", Stats.getNativeVersion());
            kvMap.put("mid", mMid);
            kvMap.put("os", os.toString());
            kvMap.put("tm", String.valueOf(System.currentTimeMillis()));
            kvMap.put("r", String.valueOf(new Random().nextInt(Integer.MAX_VALUE)));
            if (mContext != null) {
                kvMap.put(SESSION_PARAM_APP_PACKANGE_NAME, mContext.getPackageName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return kvMap;
    }

    static {
        mJniInit = false;
        Stats.loadLibrary();
    }
}

