/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.tools;

import android.text.TextUtils;
import com.qihoo.livecloud.tools.Logger;
import com.qihoo.livecloud.tools.Stats;

public class Version {
    private static final String TAG = "Version";
    public static final String V_2_0_0 = "2.0.0.0";
    public static final String V_2_0_1 = "2.0.1.0";
    public static final String V_2_0_2 = "2.0.2.0";
    public static final String V_2_0_3 = "2.0.3.0";

    public static String getPubLibVersion() {
        String nowPubLibVersion = "0.0.0.0";
        try {
            nowPubLibVersion = Stats.getVersion();
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
        }
        int end = nowPubLibVersion.indexOf("_");
        if (end > 0) {
            nowPubLibVersion = nowPubLibVersion.substring(0, end);
        }
        return nowPubLibVersion;
    }

    public static void check(String minPubLibVersion) {
        if (TextUtils.isEmpty((CharSequence)minPubLibVersion)) {
            throw new IllegalArgumentException("must set min version");
        }
        String nowPubLibVersion = Version.getPubLibVersion();
        Logger.d(TAG, "min_version: " + minPubLibVersion + ", now_version: " + nowPubLibVersion);
        if (nowPubLibVersion != null && nowPubLibVersion.startsWith("0.0.0")) {
            return;
        }
        if (Version.compare(nowPubLibVersion, minPubLibVersion) < 0) {
            throw new RuntimeException("version too low, please update public library sdk version to " + minPubLibVersion);
        }
    }

    public static int compare(String version1, String version2) {
        if (TextUtils.isEmpty((CharSequence)version1) && TextUtils.isEmpty((CharSequence)version2)) {
            return 0;
        }
        if (TextUtils.isEmpty((CharSequence)version1)) {
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)version2)) {
            return 1;
        }
        String[] v1 = version1.split("\\.");
        String[] v2 = version2.split("\\.");
        for (int i = 0; i < v1.length && i < v2.length; ++i) {
            long diff = Long.parseLong(v1[i]) - Long.parseLong(v2[i]);
            if (diff == 0L) continue;
            return (int)diff;
        }
        if (v1.length != v2.length) {
            return v1.length - v2.length;
        }
        return 0;
    }
}

