/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.utils;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.qihoo.livecloud.tools.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtils {
    private static final String TAG = FileUtils.class.getSimpleName();
    private static final String FLODER_NAME = "photo";

    public static void createDir(String dir) {
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static String getDir(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        int index = path.lastIndexOf(File.separator);
        return path.substring(0, index);
    }

    public static String getFileName(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        int index = path.lastIndexOf(File.separator);
        return path.substring(index + 1, path.length());
    }

    public static boolean copyFile(String srcPath, String destPath) {
        return FileUtils.copyFile(new File(srcPath), new File(destPath));
    }

    public static boolean copyFile(File src, File dest) {
        try {
            if (!dest.getParentFile().exists()) {
                dest.getParentFile().mkdirs();
            }
            if (!dest.exists()) {
                dest.createNewFile();
            }
            FileOutputStream outputStream = new FileOutputStream(dest);
            FileInputStream inputStream = new FileInputStream(src);
            DataInputStream dataInput = new DataInputStream(inputStream);
            DataOutputStream dataOutput = new DataOutputStream(outputStream);
            byte[] wxj = new byte[1024];
            int length = dataInput.read(wxj);
            while (length != -1) {
                dataOutput.write(wxj, 0, length);
                length = dataInput.read(wxj);
            }
            outputStream.close();
            inputStream.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveDataToFile(byte[] data, String newPath) {
        FileOutputStream fs = null;
        try {
            fs = new FileOutputStream(newPath);
            fs.write(data, 0, data.length);
            fs.flush();
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public static long getFileSize(File f) {
        File[] fList;
        long size = 0L;
        for (File per : fList = f.listFiles()) {
            if (per.isDirectory()) {
                size += FileUtils.getFileSize(per);
                continue;
            }
            size += per.length();
        }
        return size;
    }

    public static File getLatestFile(File[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        long lastMod = Long.MIN_VALUE;
        File choice = null;
        for (File file : files) {
            if (file.isDirectory() || file.lastModified() <= lastMod) continue;
            choice = file;
            lastMod = file.lastModified();
        }
        return choice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uri getImageContentUri(Context context, File imageFile) {
        String filePath = imageFile.getAbsolutePath();
        Cursor cursor = null;
        try {
            cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{filePath}, null);
            if (cursor != null && cursor.moveToFirst()) {
                int id = cursor.getInt(cursor.getColumnIndex("_id"));
                Uri baseUri = Uri.parse((String)"content://media/external/images/media");
                Uri uri = Uri.withAppendedPath((Uri)baseUri, (String)("" + id));
                return uri;
            }
            if (imageFile.exists()) {
                ContentValues values = new ContentValues();
                values.put("_data", filePath);
                Uri baseUri = context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
                return baseUri;
            }
            Uri uri = null;
            return uri;
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception e) {
                    Logger.e("Logger", "Logger, " + e.getMessage());
                }
            }
        }
    }

    public static void deleteFile(String filepath) {
        File file = new File(filepath);
        if (file.exists()) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null && files.length > 0) {
                File[] delFiles;
                for (File delFile : delFiles = file.listFiles()) {
                    FileUtils.deleteFile(delFile.getAbsolutePath());
                }
            }
            file.delete();
        }
    }
}

