/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.utils;

import android.content.Context;
import android.content.SharedPreferences;

public class PreferencesUtils {
    private Context mContext;
    private String mPrefName;

    public PreferencesUtils(Context context, String pref_name) {
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
        this.mPrefName = pref_name;
    }

    public void putString(String key, String value) {
        SharedPreferences sp = this.mContext.getSharedPreferences(this.mPrefName, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public String getString(String key) {
        SharedPreferences sp = this.mContext.getSharedPreferences(this.mPrefName, 0);
        return sp.getString(key, "");
    }

    public void putBoolean(String key, boolean value) {
        SharedPreferences sp = this.mContext.getSharedPreferences(this.mPrefName, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean(key, value);
        editor.commit();
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        SharedPreferences sp = this.mContext.getSharedPreferences(this.mPrefName, 0);
        return sp.getBoolean(key, defaultValue);
    }

    public void putLong(String key, long value) {
        SharedPreferences sp = this.mContext.getSharedPreferences(this.mPrefName, 0);
        SharedPreferences.Editor editor = sp.edit();
        try {
            editor.putString(key, String.valueOf(value));
        }
        catch (Exception e) {
            editor.putLong(key, value);
        }
        editor.commit();
    }

    public long getLong(String key, long defaultValue) {
        String str;
        SharedPreferences sp = this.mContext.getSharedPreferences(this.mPrefName, 0);
        try {
            str = sp.getString(key, null);
        }
        catch (Exception e) {
            return sp.getLong(key, defaultValue);
        }
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }
}

