/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.livecloud.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final int BUFF_SIZE = 0x100000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFiles(Collection<File> resFileList, File zipFile) throws IOException {
        try (ZipOutputStream zipout = null;){
            zipout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 0x100000));
            for (File resFile : resFileList) {
                ZipUtils.zipFile(resFile, zipout, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFiles(Collection<File> resFileList, File zipFile, String comment) throws IOException {
        try (ZipOutputStream zipout = null;){
            zipout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 0x100000));
            for (File resFile : resFileList) {
                ZipUtils.zipFile(resFile, zipout, "");
            }
            zipout.setComment(comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upZipFile(File zipFile, String folderPath) throws ZipException, IOException {
        File desDir = new File(folderPath);
        if (!desDir.exists()) {
            desDir.mkdirs();
        }
        ZipFile zf = new ZipFile(zipFile);
        InputStream in = null;
        OutputStream out = null;
        try {
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                int realLength;
                ZipEntry entry = entries.nextElement();
                in = zf.getInputStream(entry);
                String str = folderPath + File.separator + entry.getName();
                File desFile = new File(str = new String(str.getBytes("8859_1"), Charset.forName("UTF-8")));
                if (!desFile.exists()) {
                    File fileParentDir = desFile.getParentFile();
                    if (!fileParentDir.exists()) {
                        fileParentDir.mkdirs();
                    }
                    desFile.createNewFile();
                }
                out = new FileOutputStream(desFile);
                byte[] buffer = new byte[0x100000];
                while ((realLength = in.read(buffer)) > 0) {
                    out.write(buffer, 0, realLength);
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<File> upZipSelectedFile(File zipFile, String folderPath, String nameContains) throws ZipException, IOException {
        ArrayList<File> fileList = new ArrayList<File>();
        File desDir = new File(folderPath);
        if (!desDir.exists()) {
            desDir.mkdir();
        }
        ZipFile zf = new ZipFile(zipFile);
        InputStream in = null;
        OutputStream out = null;
        try {
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                int realLength;
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().contains(nameContains)) continue;
                in = zf.getInputStream(entry);
                String str = folderPath + File.separator + entry.getName();
                File desFile = new File(str = new String(str.getBytes("8859_1"), Charset.forName("UTF-8")));
                if (!desFile.exists()) {
                    File fileParentDir = desFile.getParentFile();
                    if (!fileParentDir.exists()) {
                        fileParentDir.mkdirs();
                    }
                    desFile.createNewFile();
                }
                out = new FileOutputStream(desFile);
                byte[] buffer = new byte[0x100000];
                while ((realLength = in.read(buffer)) > 0) {
                    out.write(buffer, 0, realLength);
                }
                fileList.add(desFile);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return fileList;
    }

    public static ArrayList<String> getEntriesNames(File zipFile) throws ZipException, IOException {
        ArrayList<String> entryNames = new ArrayList<String>();
        Enumeration<?> entries = ZipUtils.getEntriesEnumeration(zipFile);
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)entries.nextElement();
            entryNames.add(new String(ZipUtils.getEntryName(entry).getBytes(Charset.forName("UTF-8")), "8859_1"));
        }
        return entryNames;
    }

    public static Enumeration<?> getEntriesEnumeration(File zipFile) throws ZipException, IOException {
        ZipFile zf = new ZipFile(zipFile);
        return zf.entries();
    }

    public static String getEntryComment(ZipEntry entry) throws UnsupportedEncodingException {
        return new String(entry.getComment().getBytes(Charset.forName("UTF-8")), "8859_1");
    }

    public static String getEntryName(ZipEntry entry) throws UnsupportedEncodingException {
        return new String(entry.getName().getBytes(Charset.forName("UTF-8")), "8859_1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(File resFile, ZipOutputStream zipout, String rootpath) throws FileNotFoundException, IOException {
        rootpath = rootpath + (rootpath.trim().length() == 0 ? "" : File.separator) + resFile.getName();
        rootpath = new String(rootpath.getBytes("8859_1"), Charset.forName("UTF-8"));
        try (BufferedInputStream in = null;){
            if (resFile.isDirectory()) {
                File[] fileList;
                for (File file : fileList = resFile.listFiles()) {
                    ZipUtils.zipFile(file, zipout, rootpath);
                }
            } else {
                int realLength;
                byte[] buffer = new byte[0x100000];
                in = new BufferedInputStream(new FileInputStream(resFile), 0x100000);
                zipout.putNextEntry(new ZipEntry(rootpath));
                while ((realLength = in.read(buffer)) != -1) {
                    zipout.write(buffer, 0, realLength);
                }
                in.close();
                zipout.flush();
                zipout.closeEntry();
            }
        }
    }
}

